/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelResource;
import org.slf4j.Logger;
import shetiphian.core.SideExecutor;
import shetiphian.core.common.NBTFile;
import shetiphian.core.mixins.SPC_Accessor_DataStorage;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.common.misc.EnderContainer;
import shetiphian.endertanks.common.misc.LocationManager;

public class TankHelper {
    public static final TankHelper INSTANCE = new TankHelper();
    private static final Table<String, String, EnderContainer> DATABASE = HashBasedTable.create();
    private static final Table<String, String, EnderContainer> CLIENT_CACHE = HashBasedTable.create();
    private static final SavedData.Factory<TankSaveData> SAVE_DATA_TYPE = new SavedData.Factory(TankSaveData::new, TankSaveData::load, null);
    private static TankSaveData SAVE_INSTANCE;
    private DataFixer saveFixer;
    private static boolean needsSaving;
    private static boolean isLoaded;
    private static String saveDir;
    private static final DateTimeFormatter TIME_FORMATTER;

    private static EnderContainer getTankData(Level world, String owner, String code) {
        Table<String, String, EnderContainer> database = world == null ? (SideExecutor.isLogicalServer() ? DATABASE : CLIENT_CACHE) : (world.isClientSide() ? CLIENT_CACHE : DATABASE);
        EnderContainer tank = (EnderContainer)database.get((Object)(owner = owner.toLowerCase()), (Object)(code = code.toUpperCase()));
        if (tank == null) {
            tank = new EnderContainer(owner, code);
            database.put((Object)owner, (Object)code, (Object)tank);
        }
        return tank;
    }

    public static EnderContainer getTank(Level world, String owner, String code) {
        return TankHelper.getTankData(world, owner, code);
    }

    public static short getCapacityInBuckets(Level world, String owner, String code) {
        return (short)TankHelper.getTankData(world, owner, code).getCapacity();
    }

    public static void setCapacityInBuckets(Level world, String owner, String code, short capacity) {
        TankHelper.getTankData(world, owner, code).setCapacity(capacity);
    }

    public static void setNeedsSaving() {
        if (SAVE_INSTANCE != null) {
            needsSaving = true;
            SAVE_INSTANCE.setDirty();
        }
    }

    public void onWorldLoad(MinecraftServer server, ServerLevel world, Function<String, LevelResource> getter) {
        SPC_Accessor_DataStorage storageAccessor;
        saveDir = server.getWorldPath(getter.apply("data/endertanks")).toString();
        DimensionDataStorage dataStorage = world.getDataStorage();
        if (dataStorage instanceof SPC_Accessor_DataStorage) {
            storageAccessor = (SPC_Accessor_DataStorage)dataStorage;
            this.saveFixer = storageAccessor.getFixerUpper();
        }
        if ((SAVE_INSTANCE = (TankSaveData)dataStorage.get(SAVE_DATA_TYPE, "endertanks")) == null) {
            if (dataStorage instanceof SPC_Accessor_DataStorage) {
                storageAccessor = (SPC_Accessor_DataStorage)dataStorage;
                SAVE_INSTANCE = (TankSaveData)((Object)SAVE_DATA_TYPE.deserializer().apply(null, storageAccessor.getRegistries()));
            } else {
                SAVE_INSTANCE = (TankSaveData)((Object)SAVE_DATA_TYPE.constructor().get());
            }
            dataStorage.set("endertanks", (SavedData)SAVE_INSTANCE);
        }
    }

    private void saveTankData(HolderLookup.Provider provider) {
        if (Strings.isNullOrEmpty((String)saveDir)) {
            saveDir = "sp_recovery" + File.separator + "endertanks" + File.separator + TIME_FORMATTER.format(LocalDateTime.now());
            EnderTanks.LOGGER.error("World Save Directory Unknown, Saving to Recovery Folder: " + saveDir);
        }
        Set networks = DATABASE.rowKeySet();
        for (String owner : networks) {
            Map networkMap = DATABASE.row((Object)owner);
            CompoundTag fileNBT = new CompoundTag();
            for (Map.Entry pocket : networkMap.entrySet()) {
                EnderContainer tank = (EnderContainer)pocket.getValue();
                CompoundTag nbtPocket = tank.save(provider);
                if (nbtPocket == null || nbtPocket.isEmpty()) continue;
                fileNBT.put((String)pocket.getKey(), (Tag)nbtPocket);
            }
            NbtUtils.addCurrentDataVersion((CompoundTag)fileNBT);
            NBTFile.write((CompoundTag)fileNBT, (File)this.getSaveFile(owner), (Logger)EnderTanks.LOGGER);
        }
        needsSaving = false;
    }

    private void loadTankData(HolderLookup.Provider provider) {
        LocationManager.clear();
        int gameDataVersion = SharedConstants.getCurrentVersion().getDataVersion().getVersion();
        List<File> fileList = this.getSaveFiles();
        for (File file : fileList) {
            String owner = this.getOwnerID(file.getName().replace(".dat", "")).toLowerCase();
            CompoundTag fileNBT = NBTFile.read((File)file, (Logger)EnderTanks.LOGGER);
            int fileDataVersion = NbtUtils.getDataVersion((CompoundTag)fileNBT, (int)1343);
            for (String code : fileNBT.getAllKeys()) {
                CompoundTag data = fileNBT.getCompound(code);
                code = code.toUpperCase();
                DATABASE.put((Object)owner, (Object)code, (Object)new EnderContainer(owner, code).load(data, provider, this.saveFixer, fileDataVersion, gameDataVersion));
            }
        }
        isLoaded = true;
    }

    public void unloadTankData() {
        boolean doMessage = false;
        if (isLoaded) {
            EnderTanks.LOGGER.debug("Unloading EnderTank Data");
            doMessage = true;
        }
        CLIENT_CACHE.clear();
        DATABASE.clear();
        isLoaded = false;
        LocationManager.clear();
        if (doMessage) {
            EnderTanks.LOGGER.info("EnderTank Data Unloaded");
        }
    }

    private List<File> getSaveFiles() {
        ArrayList<File> fileList = new ArrayList<File>();
        File[] listOfFiles = null;
        try {
            File saveFolder = new File(saveDir);
            listOfFiles = saveFolder.listFiles();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                if (!file.isFile() || !file.canRead() || !file.getName().endsWith(".dat")) continue;
                fileList.add(file);
            }
        }
        return fileList;
    }

    private File getSaveFile(String owner) {
        File file = new File(saveDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(saveDir, this.getSaveID(owner) + ".dat")).exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception error) {
                EnderTanks.LOGGER.error("Could Not Read or Create File: " + file.toString(), (Throwable)error);
            }
        }
        return file;
    }

    private String getSaveID(String owner) {
        return owner.equalsIgnoreCase("all") ? "[-Public-]" : owner;
    }

    private String getOwnerID(String owner) {
        return owner.equalsIgnoreCase("[-Public-]") ? "all" : owner;
    }

    static {
        needsSaving = false;
        isLoaded = false;
        saveDir = null;
        TIME_FORMATTER = DateTimeFormatter.ofPattern("yy-MM-dd-HH-mm");
    }

    private static class TankSaveData
    extends SavedData {
        private TankSaveData() {
        }

        public CompoundTag save(CompoundTag doNotEdit, HolderLookup.Provider provider) {
            if (needsSaving && isLoaded) {
                EnderTanks.LOGGER.debug("Saving EnderTank Data");
                INSTANCE.saveTankData(provider);
                EnderTanks.LOGGER.info("EnderTank Data Saved");
            }
            return doNotEdit;
        }

        private static TankSaveData load(CompoundTag doNotEdit, HolderLookup.Provider provider) {
            INSTANCE.unloadTankData();
            EnderTanks.LOGGER.debug("Loading EnderTank Data");
            INSTANCE.loadTankData(provider);
            EnderTanks.LOGGER.info("EnderTank Data Loaded");
            return new TankSaveData();
        }
    }
}

