/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import shetiphian.core.platform.Services;
import shetiphian.endertanks.Roster;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class LocationManager {
    private static final Table<String, String, List<TileReference>> LOCATIONS = HashBasedTable.create();

    static void clear() {
        LOCATIONS.clear();
    }

    public static void set(String owner, String code, TileEntityEnderTank tile) {
        ArrayList<TileReference> list = (ArrayList<TileReference>)LOCATIONS.get((Object)owner, (Object)code);
        if (list == null) {
            list = new ArrayList<TileReference>();
            LOCATIONS.put((Object)owner, (Object)code, list);
        }
        list.add(new TileReference(tile));
    }

    public static void clear(String owner, String code, TileEntityEnderTank tile) {
        List list = (List)LOCATIONS.get((Object)owner, (Object)code);
        if (list != null) {
            list.remove((Object)tile);
            if (list.isEmpty()) {
                LOCATIONS.remove((Object)owner, (Object)code);
            }
        }
    }

    public static void doBlockUpdate(String owner, String code) {
        MinecraftServer server = Services.NETWORK.getCurrentServer();
        if (server != null) {
            server.execute(() -> LocationManager.preformBlockUpdate(owner, code));
        }
    }

    private static void preformBlockUpdate(String owner, String code) {
        List locations = (List)LOCATIONS.get((Object)owner, (Object)code);
        if (locations != null && !locations.isEmpty()) {
            UnmodifiableIterator iterator = ImmutableList.copyOf((Collection)locations).iterator();
            iterator.forEachRemaining(reference -> {
                TileEntityEnderTank tile = (TileEntityEnderTank)((Object)((Object)reference.get()));
                if (tile != null && !tile.isRemoved() && tile.hasLevel()) {
                    Level world = tile.getLevel();
                    if (world.hasChunkAt(tile.getBlockPos())) {
                        world.updateNeighborsAt(tile.getBlockPos(), (Block)Roster.Blocks.ENDERTANK.get());
                        world.updateNeighbourForOutputSignal(tile.getBlockPos(), (Block)Roster.Blocks.ENDERTANK.get());
                    }
                } else {
                    locations.remove(reference);
                }
            });
        }
        if (locations == null || locations.isEmpty()) {
            LOCATIONS.remove((Object)owner, (Object)code);
        }
    }

    private static class TileReference
    extends WeakReference<TileEntityEnderTank> {
        private TileReference(TileEntityEnderTank referent) {
            super(referent);
        }

        public boolean equals(Object object) {
            TileEntityEnderTank myTile = (TileEntityEnderTank)((Object)this.get());
            if (myTile != null) {
                if (object instanceof TileEntityEnderTank) {
                    return ((Object)((Object)myTile)).equals(object);
                }
                if (object instanceof TileReference) {
                    return ((Object)((Object)myTile)).equals(((TileReference)object).get());
                }
            }
            return false;
        }
    }
}

