/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.datafixers.DataFixer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResultHolder;
import shetiphian.endertanks.Configs;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.IEnderTankInfo;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.common.misc.LocationManager;
import shetiphian.endertanks.common.misc.TankHelper;

public class EnderContainer
implements IEnderTankInfo {
    private final HashMap<String, ITankHandler<?>> handlers = new HashMap();
    private final HashMap<String, CompoundTag> missing_handlers = new HashMap();
    private final Table<String, String, ITankHandler<?>> locked_handlers = HashBasedTable.create();
    private final String owner;
    private final String code;
    private int capacity;

    public EnderContainer(String owner, String code) {
        this.capacity = Configs.PROCESSED.tankSizeMin.get();
        this.owner = owner;
        this.code = code;
    }

    public EnderContainer load(CompoundTag nbtTank, HolderLookup.Provider provider, DataFixer dataFixer, int fileDataVersion, int gameDataVersion) {
        if (nbtTank.contains("capacity", 2)) {
            this.capacity = Mth.clamp((int)nbtTank.getShort("capacity"), (int)Configs.PROCESSED.tankSizeMin.get(), (int)Configs.PROCESSED.tankSizeMax.get());
        } else if (nbtTank.contains("Capacity", 2)) {
            this.capacity = Mth.clamp((int)nbtTank.getShort("Capacity"), (int)Configs.PROCESSED.tankSizeMin.get(), (int)Configs.PROCESSED.tankSizeMax.get());
        }
        for (String key : nbtTank.getAllKeys()) {
            if (nbtTank.getTagType(key) != 10) continue;
            CompoundTag nbtData = nbtTank.getCompound(key);
            ITankHandler<?> handler = HandlerRegistry.createHandlerFor(key, (IEnderTankInfo)this);
            if (handler != null) {
                handler.setCapacity(this.capacity);
                if (fileDataVersion != gameDataVersion && dataFixer != null) {
                    nbtData = handler.updateData(nbtData, dataFixer, fileDataVersion, gameDataVersion);
                }
                handler.load(nbtData, provider);
                this.handlers.put(key, handler);
                continue;
            }
            String providerId = HandlerRegistry.getProviderId(key);
            InteractionResultHolder<String> resultHolder = providerId != null ? InteractionResultHolder.success((Object)providerId) : EnderTanks.PLATFORM.fireMissingHandlerEvent(key, nbtData.copy());
            switch (resultHolder.getResult()) {
                case SUCCESS: {
                    String newKey = (String)resultHolder.getObject();
                    if (this.handlers.containsKey(newKey)) {
                        this.missing_handlers.put(key, nbtData);
                    }
                    if ((handler = HandlerRegistry.createHandlerFor(newKey, (IEnderTankInfo)this)) != null) {
                        handler.setCapacity(this.capacity);
                        nbtData = handler.portFromOldProvider(nbtData, key);
                        if (fileDataVersion != gameDataVersion && dataFixer != null) {
                            nbtData = handler.updateData(nbtData, dataFixer, fileDataVersion, gameDataVersion);
                        }
                        if (nbtData.isEmpty()) break;
                        handler.load(nbtData, provider);
                        if (!this.handlers.containsKey(newKey)) {
                            this.handlers.put(newKey, handler);
                            break;
                        }
                        this.locked_handlers.put((Object)key, (Object)newKey, handler);
                        break;
                    }
                }
                case CONSUME: 
                case PASS: {
                    this.missing_handlers.put(key, nbtData);
                    break;
                }
            }
        }
        return this;
    }

    public CompoundTag save(HolderLookup.Provider provider) {
        CompoundTag nbtHandler;
        CompoundTag nbtTank = new CompoundTag();
        if (this.capacity > Configs.PROCESSED.tankSizeMin.get()) {
            nbtTank.putShort("capacity", (short)this.capacity);
        }
        block0: for (Map.Entry<String, ITankHandler<?>> entry : this.handlers.entrySet()) {
            nbtHandler = entry.getValue().save(provider);
            if (nbtHandler != null && !nbtHandler.isEmpty()) {
                nbtTank.put(entry.getKey(), (Tag)nbtHandler);
                continue;
            }
            if (!this.locked_handlers.columnKeySet().contains(entry.getKey())) continue;
            Iterator iterator = this.locked_handlers.cellSet().iterator();
            while (iterator.hasNext()) {
                Table.Cell entry2 = (Table.Cell)iterator.next();
                if (!Objects.equals(entry2.getColumnKey(), entry.getKey())) continue;
                entry.setValue((ITankHandler)entry2.getValue());
                this.missing_handlers.remove(entry2.getRowKey());
                iterator.remove();
                nbtHandler = ((ITankHandler)entry2.getValue()).save(provider);
                if (nbtHandler == null || nbtHandler.isEmpty()) continue block0;
                nbtTank.put(entry.getKey(), (Tag)nbtHandler);
                continue block0;
            }
        }
        for (Map.Entry<String, ITankHandler<?>> entry : this.missing_handlers.entrySet()) {
            nbtHandler = (CompoundTag)entry.getValue();
            if (nbtHandler == null || nbtHandler.isEmpty()) continue;
            nbtTank.put(entry.getKey(), (Tag)nbtHandler);
        }
        return nbtTank;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        for (ITankHandler<?> handler : this.handlers.values()) {
            handler.setCapacity(capacity);
        }
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void notifyContentsChange() {
        TankHelper.setNeedsSaving();
        LocationManager.doBlockUpdate(this.owner, this.code);
    }

    public ITankHandler<?> getOrCreateHandler(String providerId) {
        if (this.handlers.containsKey(providerId)) {
            return this.handlers.get(providerId);
        }
        ITankHandler<?> handler = HandlerRegistry.createHandlerFor(providerId, (IEnderTankInfo)this);
        if (handler != null) {
            this.handlers.put(providerId, handler);
        }
        return handler;
    }

    public <T> Optional<T> getTankFor(Class<T> type) {
        return this.getTankFor(type, StorageAccessMode.FULL);
    }

    public <T> Optional<T> getTankFor(Class<T> type, StorageAccessMode access) {
        ITankHandler<?> handler = this.getOrCreateHandler(HandlerRegistry.getProviderId(type));
        if (handler != null) {
            return Optional.of(handler.getTank(access));
        }
        return Optional.empty();
    }

    @Override
    public List<MutableComponent> getContentsInfo(boolean bucket) {
        ArrayList<MutableComponent> info = new ArrayList<MutableComponent>();
        for (ITankHandler<?> handler : this.handlers.values()) {
            MutableComponent entry;
            if (bucket && !EnderTanks.PLATFORM.isBucketHandler(handler) || (entry = handler.getContentsInfo()) == null) continue;
            info.add(entry);
        }
        if (!bucket) {
            this.locked_handlers.cellSet().forEach(cell -> {
                MutableComponent entry = ((ITankHandler)cell.getValue()).getContentsInfo();
                if (entry != null) {
                    info.add(Component.literal((String)"\u231a").append((Component)entry));
                }
            });
        }
        if (info.isEmpty()) {
            info.add(Component.literal((String)" ").append((Component)Component.translatable((String)"info.endertanks.tank.empty")).append(" [0/" + this.capacity + "K mB]"));
        }
        return info;
    }

    public int getComparatorOutput(String key) {
        ITankHandler<?> handler = this.handlers.get(key);
        if (handler != null) {
            return handler.getComparatorOutput();
        }
        return -1;
    }

    public Component getDisplayName(String key) {
        ITankHandler<?> handler = this.getOrCreateHandler(key);
        if (handler != null) {
            return handler.getDisplayName();
        }
        return Component.literal((String)"nil");
    }
}

