/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.item;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import shetiphian.core.SideExecutor;
import shetiphian.core.client.ClientHelpers;
import shetiphian.core.client.ColorHandler;
import shetiphian.core.common.Helpers;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ITabFiller;
import shetiphian.core.common.item.IToolMode;
import shetiphian.endertanks.Configs;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.Roster;
import shetiphian.endertanks.common.component.BucketMode;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class ItemEnderBucket
extends Item
implements ITabFiller,
IColored,
IToolMode {
    public ItemEnderBucket(Item.Properties properties) {
        super(properties);
        SideExecutor.runOnClient(() -> () -> {
            ColorHandler.colorize((IColored)this);
            ClientHelpers.addProperty((Item)this, (String)"type", (stack, world, entity, seed) -> StackHelper.isPublic(stack) ? 0.0f : (StackHelper.isTeam(stack) ? 2.0f : 1.0f));
        });
    }

    public void fillCreativeTab(CreativeModeTab.Output entries, CreativeModeTab.ItemDisplayParameters context) {
        for (String code : StackHelper.BASE_CODES) {
            entries.accept(StackHelper.create(this, code, "all"));
        }
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        StackHelper.cleanOutOldNbt(stack);
    }

    public void onCraftedBy(ItemStack stack, Level world, Player player) {
        if (!((Boolean)Configs.ACCESS_SETTINGS.allowPublicBuckets.get()).booleanValue() && StackHelper.isPublic(stack)) {
            if (!((Boolean)Configs.ACCESS_SETTINGS.allowPersonalBuckets.get()).booleanValue()) {
                String teamID = Helpers.getPlayerTeamID((Player)player);
                if (!Strings.isNullOrEmpty((String)teamID)) {
                    StackHelper.setOwner(stack, "#" + teamID);
                }
            } else {
                StackHelper.setOwner(stack, player.getUUID().toString());
            }
        }
    }

    private static BucketMode.Enum getMode(ItemStack stack) {
        return ((BucketMode)stack.getOrDefault((DataComponentType)Roster.DataComponents.BUCKET_MODE.get(), (Object)BucketMode.DEFAULT)).mode();
    }

    private static ItemStack setMode(ItemStack stack, BucketMode.Enum mode) {
        stack.set((DataComponentType)Roster.DataComponents.BUCKET_MODE.get(), (Object)new BucketMode(mode));
        return stack;
    }

    public boolean changeMode(Player player, ItemStack stack, boolean reverse) {
        if (!stack.isEmpty() && stack.getItem() instanceof ItemEnderBucket) {
            BucketMode.Enum mode = ItemEnderBucket.getMode(stack).next(reverse);
            ItemEnderBucket.setMode(stack, mode);
            if (player != null) {
                TankInfoHelper.sendInfo(player, Component.translatable((String)mode.getTooltip()));
            }
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide()) {
            boolean shouldPlaceFluid = ItemEnderBucket.getMode(stack).preformsPlace(player.isShiftKeyDown());
            BlockPos pos = null;
            boolean hitTypeBlock = false;
            Direction facing = Direction.getRandom((RandomSource)world.random);
            BlockHitResult mop = ItemEnderBucket.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)(!shouldPlaceFluid ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
            if (mop != null && mop.getType() != HitResult.Type.MISS) {
                hitTypeBlock = true;
                pos = mop.getBlockPos();
                facing = mop.getDirection();
            }
            if (pos != null && world.getBlockState(pos).getBlock() == Roster.Blocks.ENDERTANK.get()) {
                BlockEntity tile;
                if (player.isShiftKeyDown() && (tile = world.getBlockEntity(pos)) instanceof TileEntityEnderTank) {
                    TileEntityEnderTank tankTile = (TileEntityEnderTank)tile;
                    if (tankTile.hasError()) {
                        TankInfoHelper.sendLinkError(player, 2);
                    } else {
                        if (tankTile.canLink(player)) {
                            if (((Boolean)Configs.GENERAL.fullStackLinking.get()).booleanValue()) {
                                StackHelper.setLink(stack, tankTile.getCode(), tankTile.getOwnerID());
                            } else {
                                Helpers.giveItem((Player)player, (ItemStack)StackHelper.setLink(stack.split(1), tankTile.getCode(), tankTile.getOwnerID()));
                            }
                            return InteractionResultHolder.success((Object)stack);
                        }
                        TankInfoHelper.sendLinkError(player, tankTile.isTeam() ? 3 : 1);
                    }
                }
                return InteractionResultHolder.success((Object)stack);
            }
            if (!StackHelper.isPublic(stack) || ((Boolean)Configs.ACCESS_SETTINGS.allowPublicBuckets.get()).booleanValue()) {
                boolean showInfo = true;
                if (pos != null) {
                    showInfo = shouldPlaceFluid ? EnderTanks.PLATFORM.placeLiquid(stack, player, hand, world, pos, facing, hitTypeBlock) : EnderTanks.PLATFORM.pickupLiquid(stack, player, hand, world, pos, facing);
                }
                if (showInfo) {
                    String[] network = new String[]{StackHelper.getOwnerID(stack), StackHelper.getCode(stack)};
                    TankInfoHelper.sendTankInfo(player, StackHelper.getOwnerName(stack), network[0], network[1], false);
                }
            } else {
                TankInfoHelper.sendError(player, "endertanks.bucket.public.disabled");
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public String getDescriptionId(ItemStack stack) {
        return "item.endertanks.bucket." + (StackHelper.isPublic(stack) ? "public" : (StackHelper.isTeam(stack) ? "team" : "private"));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"info.endertanks.tank.code")).append((Component)Component.literal((String)(" " + StackHelper.getCode(stack)))));
        Component owner = TankInfoHelper.formatTankOwner(StackHelper.getOwnerName(stack));
        if (owner != null) {
            tooltip.add(owner);
        }
        tooltip.add((Component)Component.translatable((String)ItemEnderBucket.getMode(stack).getTooltip()));
        ADD_CHANGE_INSTRUCTIONS.accept(tooltip, null);
    }

    public int getColorFor(IColored.Data data, int index) {
        if (index > 0 && index < 4 && !data.stack.isEmpty()) {
            int value = Mth.clamp((int)Integer.parseInt("" + StackHelper.getCode(data.stack).charAt(index - 1), 16), (int)0, (int)16);
            return Configs.PROCESSED.colorValues[value];
        }
        return -1;
    }
}

