/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import shetiphian.endertanks.Roster;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.mixins.ET_Accessor_Cauldron;

public final class CauldronHelper {
    public static void register() {
        CauldronInteraction.EMPTY.map().put((Item)Roster.Items.ENDERBUCKET.get(), (state, world, pos, player, hand, stack) -> CauldronHelper.fillCauldron(state, world, pos, player, stack, CauldronHelper.getTank(stack, world)));
        CauldronInteraction.WATER.map().put((Item)Roster.Items.ENDERBUCKET.get(), (state, world, pos, player, hand, stack) -> CauldronHelper.drainCauldron(state, world, pos, player, stack, CauldronHelper.getTank(stack, world), (Fluid)Fluids.WATER, (TagKey<Fluid>)FluidTags.WATER, Blocks.CAULDRON.defaultBlockState(), cauldron -> cauldron.hasProperty((Property)LayeredCauldronBlock.LEVEL) && (Integer)cauldron.getValue((Property)LayeredCauldronBlock.LEVEL) == 3));
        CauldronInteraction.LAVA.map().put((Item)Roster.Items.ENDERBUCKET.get(), (state, world, pos, player, hand, stack) -> CauldronHelper.drainCauldron(state, world, pos, player, stack, CauldronHelper.getTank(stack, world), (Fluid)Fluids.LAVA, (TagKey<Fluid>)FluidTags.LAVA, Blocks.CAULDRON.defaultBlockState(), cauldron -> cauldron.getBlock() == Blocks.LAVA_CAULDRON));
    }

    private static IFluidHandler getTank(ItemStack stack, Level world) {
        return TankHelper.getTank(world, StackHelper.getOwnerID(stack), StackHelper.getCode(stack)).getTankFor(IFluidHandler.class).orElse(null);
    }

    public static void drainCauldron(BlockState cauldron, Level world, BlockPos pos, IFluidHandler eTankHandler) {
        Block block = cauldron.getBlock();
        if (block instanceof ET_Accessor_Cauldron) {
            ET_Accessor_Cauldron block2 = (ET_Accessor_Cauldron)block;
            CauldronInteraction.InteractionMap map = block2.getInteractions();
            if (CauldronInteraction.WATER.equals((Object)map)) {
                CauldronHelper.drainCauldron(cauldron, world, pos, null, ItemStack.EMPTY, eTankHandler, (Fluid)Fluids.WATER, (TagKey<Fluid>)FluidTags.WATER, Blocks.CAULDRON.defaultBlockState(), state -> state.hasProperty((Property)LayeredCauldronBlock.LEVEL) && (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) == 3);
            } else if (CauldronInteraction.LAVA.equals((Object)map)) {
                CauldronHelper.drainCauldron(cauldron, world, pos, null, ItemStack.EMPTY, eTankHandler, (Fluid)Fluids.LAVA, (TagKey<Fluid>)FluidTags.LAVA, Blocks.CAULDRON.defaultBlockState(), state -> state.getBlock() == Blocks.LAVA_CAULDRON);
            }
        }
    }

    private static ItemInteractionResult drainCauldron(BlockState cauldron, Level world, BlockPos pos, Player player, ItemStack stack, IFluidHandler eTankHandler, Fluid fluid, TagKey<Fluid> tag, BlockState emptyCauldron, Predicate<BlockState> isCauldronFull) {
        if (isCauldronFull.test(cauldron) && eTankHandler != null && emptyCauldron != null) {
            FluidStack fluidInTank = eTankHandler.getFluidInTank(0);
            if (eTankHandler.getTankCapacity(0) - fluidInTank.getAmount() >= 1000 && tag != null && (fluidInTank.isEmpty() || fluidInTank.getFluid().is(tag))) {
                Fluid fluid2 = fluid = !fluidInTank.isEmpty() ? fluidInTank.getFluid() : fluid;
                if (fluid != null) {
                    if (!world.isClientSide()) {
                        FluidStack fillFluid = new FluidStack(fluid, 1000);
                        world.setBlockAndUpdate(pos, emptyCauldron);
                        if (player != null) {
                            player.awardStat(Stats.USE_CAULDRON);
                            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                            SoundEvent sound = fluid.getFluidType().getSound(SoundActions.BUCKET_FILL);
                            if (sound != null) {
                                world.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                            }
                            world.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, pos);
                        }
                        if (player == null || !player.getAbilities().instabuild) {
                            eTankHandler.fill(fillFluid, IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                    return ItemInteractionResult.SUCCESS;
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static void fillCauldron(BlockState cauldron, Level world, BlockPos pos, IFluidHandler eTankHandler) {
        CauldronHelper.fillCauldron(cauldron, world, pos, null, ItemStack.EMPTY, eTankHandler);
    }

    private static ItemInteractionResult fillCauldron(BlockState cauldron, Level world, BlockPos pos, Player player, ItemStack stack, IFluidHandler eTankHandler) {
        BlockState filledCauldron;
        FluidStack fluidInTank;
        if (cauldron != null && eTankHandler != null && !(fluidInTank = eTankHandler.getFluidInTank(0)).isEmpty() && fluidInTank.getAmount() >= 1000 && (filledCauldron = CauldronHelper.getFilledCauldron(cauldron, fluidInTank.getFluid())) != null) {
            if (!world.isClientSide()) {
                world.setBlockAndUpdate(pos, filledCauldron);
                if (player != null) {
                    player.awardStat(Stats.FILL_CAULDRON);
                    player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                    SoundEvent sound = fluidInTank.getFluid().getFluidType().getSound(SoundActions.BUCKET_EMPTY);
                    if (sound != null) {
                        world.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    world.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
                }
                if (player == null || !player.getAbilities().instabuild) {
                    eTankHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private static BlockState getFilledCauldron(BlockState emptyCauldron, Fluid fluid) {
        if (emptyCauldron.getBlock() == Blocks.CAULDRON) {
            if (fluid.is(FluidTags.WATER)) {
                return (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3));
            }
            if (fluid.is(FluidTags.LAVA)) {
                return Blocks.LAVA_CAULDRON.defaultBlockState();
            }
        }
        return null;
    }
}

