/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks;

import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import shetiphian.endertanks.CreativeTabs;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.Roster;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.component.BucketMode;
import shetiphian.endertanks.common.component.EnderNetwork;
import shetiphian.endertanks.common.crafting.EnderRecipe;
import shetiphian.endertanks.common.item.ItemBlockEnderTank;
import shetiphian.endertanks.common.item.ItemEnderBucket;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;
import shetiphian.endertanks.modintegration.ModIntegration;

final class Registration {
    Registration(IEventBus eventBus) {
        this.dataComponents(this.create(Registries.DATA_COMPONENT_TYPE, eventBus));
        this.blocks(this.create((Registry)BuiltInRegistries.BLOCK, eventBus));
        this.tiles(this.create(BuiltInRegistries.BLOCK_ENTITY_TYPE, eventBus));
        this.items(this.create((Registry)BuiltInRegistries.ITEM, eventBus));
        this.recipes(this.create(BuiltInRegistries.RECIPE_TYPE, eventBus));
        this.recipeSerializers(this.create(BuiltInRegistries.RECIPE_SERIALIZER, eventBus));
        CreativeTabs.init(eventBus);
        eventBus.addListener(ModIntegration.INSTANCE::registerCapabilities);
    }

    private <T> DeferredRegister<T> create(Registry<T> registry, IEventBus eventBus) {
        return this.create(registry.key(), eventBus);
    }

    private <T> DeferredRegister<T> create(ResourceKey<? extends Registry<T>> key, IEventBus eventBus) {
        DeferredRegister registry = DeferredRegister.create(key, (String)"endertanks");
        registry.register(eventBus);
        return registry;
    }

    private void dataComponents(DeferredRegister<DataComponentType<?>> reg) {
        Roster.DataComponents.NETWORK.wrap(id -> reg.register(id, () -> DataComponentType.builder().persistent(EnderNetwork.CODEC).build()));
        Roster.DataComponents.BUCKET_MODE.wrap(id -> reg.register(id, () -> DataComponentType.builder().persistent(BucketMode.CODEC).build()));
    }

    private void blocks(DeferredRegister<Block> reg) {
        Roster.Blocks.ENDERTANK.wrap(id -> reg.register(id, BlockEnderTank::new));
    }

    private void tiles(DeferredRegister<BlockEntityType<?>> reg) {
        Roster.Tiles.ENDERTANK.wrap(id -> reg.register(id, () -> BlockEntityType.Builder.of(TileEntityEnderTank::new, (Block[])new Block[]{(Block)Roster.Blocks.ENDERTANK.get()}).build(null)));
    }

    private void items(DeferredRegister<Item> reg) {
        Roster.Items.ENDERTANK.wrap(id -> reg.register(id, () -> new ItemBlockEnderTank((Block)Roster.Blocks.ENDERTANK.get(), Registration.networkedItem())));
        Roster.Items.ENDERBUCKET.wrap(id -> reg.register(id, () -> new ItemEnderBucket(Registration.networkedItem().component((DataComponentType)Roster.DataComponents.BUCKET_MODE.get(), (Object)BucketMode.DEFAULT))));
    }

    private static Item.Properties networkedItem() {
        return Registration.stackable().component((DataComponentType)Roster.DataComponents.NETWORK.get(), (Object)EnderNetwork.DEFAULT);
    }

    private static Item.Properties stackable() {
        return new Item.Properties();
    }

    private void recipes(DeferredRegister<RecipeType<?>> reg) {
        Roster.Recipes.CRAFTING.wrap(id -> reg.register(id, () -> RecipeType.simple((ResourceLocation)EnderTanks.RESOURCE.apply((String)id))));
    }

    private void recipeSerializers(DeferredRegister<RecipeSerializer<?>> reg) {
        Roster.RecipeSerializers.CRAFTING.wrap(id -> reg.register(id, EnderRecipe.Serializer::new));
    }
}

