/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks;

import java.util.Objects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import shetiphian.endertanks.ConfigLoader;
import shetiphian.endertanks.Configs;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.Registration;
import shetiphian.endertanks.common.CauldronHelper;
import shetiphian.endertanks.common.EventHandler;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.modintegration.ModIntegration;
import shetiphian.endertanks.network.NetworkHandler;

@Mod(value="endertanks")
public final class ModMain {
    public ModMain(ModContainer modContainer, IEventBus modEventBus) {
        new Registration(modEventBus);
        new ConfigLoader(modContainer, modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(NetworkHandler::initialise);
        modEventBus.addListener(InterModEnqueueEvent.class, event -> ModIntegration.INSTANCE.init());
        NeoForge.EVENT_BUS.register((Object)new EventRelay());
        EnderTanks.CAPABILITY_DEVALID_INATOR = tile -> {
            try {
                Objects.requireNonNull(tile.getLevel()).invalidateCapabilities(tile.getBlockPos());
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(CauldronHelper::register);
    }

    private static class EventRelay
    extends EventHandler {
        private MinecraftServer bufferedServer = null;

        private EventRelay() {
        }

        @SubscribeEvent
        public void serverStarting(ServerAboutToStartEvent event) {
            this.bufferedServer = event.getServer();
        }

        @SubscribeEvent
        public void serverStopped(ServerStoppedEvent event) {
            TankHelper.INSTANCE.unloadTankData();
            Configs.CAN_PROCESS_TAGS = false;
        }

        @SubscribeEvent
        public void worldLoaded(LevelEvent.Load event) {
            ServerLevel world;
            if (this.bufferedServer != null && (world = this.bufferedServer.getLevel(Level.OVERWORLD)) != null) {
                TankHelper.INSTANCE.onWorldLoad(this.bufferedServer, world, LevelResource::new);
                this.bufferedServer = null;
            }
        }

        @SubscribeEvent
        public void tagsUpdatedEvent(TagsUpdatedEvent event) {
            EventRelay.onTagsUpdated();
        }

        @SubscribeEvent
        public void playerRightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
            InteractionResult result = EventRelay.onPlayerRightClickBlock(event.getEntity(), event.getLevel(), event.getPos(), event.getHand());
            if (result.consumesAction()) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }
}

