/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import shetiphian.core.common.ColorHelper;
import shetiphian.core.common.TagHelper;
import shetiphian.core.common.setup.ConfigObject;
import shetiphian.endertanks.EnderTanks;

public final class Configs {
    public static final Menu_General GENERAL = new Menu_General();
    static final Menu_Upgrade UPGRADE_ITEMS = new Menu_Upgrade();
    public static final Menu_Settings UPGRADE_SETTINGS = new Menu_Settings();
    public static final Menu_Access ACCESS_SETTINGS = new Menu_Access();
    public static final Menu_Integration INTEGRATION = new Menu_Integration();
    static final Menu_Color COLOR_VALUES = new Menu_Color();
    public static final Processed PROCESSED = new Processed();
    public static boolean CAN_PROCESS_TAGS = false;

    private static int getColor(ConfigObject<String> configObject) {
        return 0xFF000000 | ColorHelper.colorFromString((String)((String)configObject.get()), (String)((String)configObject.getDefault()), (Integer)-1);
    }

    static void process_client() {
        Configs.PROCESSED.colorValues[0] = Configs.getColor(Configs.COLOR_VALUES.white);
        Configs.PROCESSED.colorValues[1] = Configs.getColor(Configs.COLOR_VALUES.orange);
        Configs.PROCESSED.colorValues[2] = Configs.getColor(Configs.COLOR_VALUES.magenta);
        Configs.PROCESSED.colorValues[3] = Configs.getColor(Configs.COLOR_VALUES.light_blue);
        Configs.PROCESSED.colorValues[4] = Configs.getColor(Configs.COLOR_VALUES.yellow);
        Configs.PROCESSED.colorValues[5] = Configs.getColor(Configs.COLOR_VALUES.lime);
        Configs.PROCESSED.colorValues[6] = Configs.getColor(Configs.COLOR_VALUES.pink);
        Configs.PROCESSED.colorValues[7] = Configs.getColor(Configs.COLOR_VALUES.gray);
        Configs.PROCESSED.colorValues[8] = Configs.getColor(Configs.COLOR_VALUES.light_gray);
        Configs.PROCESSED.colorValues[9] = Configs.getColor(Configs.COLOR_VALUES.cyan);
        Configs.PROCESSED.colorValues[10] = Configs.getColor(Configs.COLOR_VALUES.purple);
        Configs.PROCESSED.colorValues[11] = Configs.getColor(Configs.COLOR_VALUES.blue);
        Configs.PROCESSED.colorValues[12] = Configs.getColor(Configs.COLOR_VALUES.brown);
        Configs.PROCESSED.colorValues[13] = Configs.getColor(Configs.COLOR_VALUES.green);
        Configs.PROCESSED.colorValues[14] = Configs.getColor(Configs.COLOR_VALUES.red);
        Configs.PROCESSED.colorValues[15] = Configs.getColor(Configs.COLOR_VALUES.black);
    }

    static void process_common() {
        int tankSizeMax;
        int tankSizeMin = (Integer)Configs.UPGRADE_SETTINGS.tankSizeMin.get();
        if (tankSizeMin > (tankSizeMax = ((Integer)Configs.UPGRADE_SETTINGS.tankSizeMax.get()).intValue())) {
            EnderTanks.LOGGER.error("Config File Error: [tankSizeMin > tankSizeMax]; will attempt to correct");
            Configs.UPGRADE_SETTINGS.tankSizeMin.update((Object)tankSizeMax);
            Configs.UPGRADE_SETTINGS.tankSizeMax.update((Object)tankSizeMin);
        }
        if ((Integer)Configs.UPGRADE_SETTINGS.tankSizeMin.get() > (Integer)Configs.UPGRADE_SETTINGS.tankSizeMax.get()) {
            EnderTanks.LOGGER.warn("Invalid Config Values Loaded: [tankSizeMin > tankSizeMax]; swapping runtime values, but file needs manual correction");
            Configs.PROCESSED.tankSizeMin = Configs.UPGRADE_SETTINGS.tankSizeMax;
            Configs.PROCESSED.tankSizeMax = Configs.UPGRADE_SETTINGS.tankSizeMin;
        }
        Configs.processTagLists();
    }

    public static void processTagLists() {
        if (CAN_PROCESS_TAGS) {
            Configs.PROCESSED.listAllUpgrades.clear();
            Configs.process((List)Configs.UPGRADE_ITEMS.convertToPersonal.get(), Configs.PROCESSED.listPersonal, "upgrade_items.convertToPersonal", Items.DIAMOND);
            Configs.process((List)Configs.UPGRADE_ITEMS.convertToTeam.get(), Configs.PROCESSED.listTeam, "upgrade_items.convertToTeam", Items.EMERALD);
            Configs.process((List)Configs.UPGRADE_ITEMS.sCapacity_multi.get(), Configs.PROCESSED.listSmallCap_Multi, "upgrade_items.small_capacity", Items.ENDER_PEARL);
            Configs.process((List)Configs.UPGRADE_ITEMS.lCapacity_multi.get(), Configs.PROCESSED.listLargeCap_Multi, "upgrade_items.large_capacity", Items.ENDER_EYE);
            Configs.process((List)Configs.UPGRADE_ITEMS.pumpCapacity_multi.get(), Configs.PROCESSED.listPump_Multi, "upgrade_items.pump_capacity", Items.PISTON);
            Configs.process((List)Configs.UPGRADE_ITEMS.sCapacity_single.get(), Configs.PROCESSED.listSmallCap_Single, "upgrade_items.small_capacity_singleuse", null);
            Configs.process((List)Configs.UPGRADE_ITEMS.lCapacity_single.get(), Configs.PROCESSED.listLargeCap_Single, "upgrade_items.large_capacity_singleuse", null);
            Configs.process((List)Configs.UPGRADE_ITEMS.pumpCapacity_single.get(), Configs.PROCESSED.listPump_Single, "upgrade_items.pump_capacity_singleuse", null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void process(List<? extends String> names, Set<Item> list, String option, Item fallback) {
        list.clear();
        for (String string : names) {
            void var5_5;
            if (Strings.isNullOrEmpty((String)string)) continue;
            boolean isTag = false;
            if (string.toLowerCase().startsWith("tag|")) {
                isTag = true;
                String string2 = string.substring(4);
            }
            if (isTag) {
                TagHelper.ITEMS.getCollection((String)var5_5).forEach(item -> Configs.addToList(item, list));
                continue;
            }
            Configs.addToList((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)var5_5)), list);
        }
        if (list.isEmpty() && !names.isEmpty()) {
            if (fallback != null) {
                list.add(fallback);
                EnderTanks.LOGGER.error("ConfigError: No resolvable item in '{}', defaulting to '{}'", (Object)option, (Object)fallback);
            } else {
                EnderTanks.LOGGER.error("ConfigError: No resolvable item in '{}'", (Object)option);
            }
        }
        Configs.PROCESSED.listAllUpgrades.addAll(list);
    }

    private static void addToList(Item item, Set<Item> list) {
        if (list != null && item != null && item != Items.AIR) {
            list.add(item);
        }
    }

    public static class Processed {
        public Supplier<Integer> tankSizeMin;
        public Supplier<Integer> tankSizeMax;
        public final int[] colorValues;
        public final Set<Item> listPersonal;
        public final Set<Item> listTeam;
        public final Set<Item> listSmallCap_Multi;
        public final Set<Item> listLargeCap_Multi;
        public final Set<Item> listPump_Multi;
        public final Set<Item> listSmallCap_Single;
        public final Set<Item> listLargeCap_Single;
        public final Set<Item> listPump_Single;
        public final Set<Item> listAllUpgrades;

        public Processed() {
            this.tankSizeMin = Configs.UPGRADE_SETTINGS.tankSizeMin;
            this.tankSizeMax = Configs.UPGRADE_SETTINGS.tankSizeMax;
            this.colorValues = new int[16];
            this.listPersonal = new HashSet<Item>();
            this.listTeam = new HashSet<Item>();
            this.listSmallCap_Multi = new HashSet<Item>();
            this.listLargeCap_Multi = new HashSet<Item>();
            this.listPump_Multi = new HashSet<Item>();
            this.listSmallCap_Single = new HashSet<Item>();
            this.listLargeCap_Single = new HashSet<Item>();
            this.listPump_Single = new HashSet<Item>();
            this.listAllUpgrades = new HashSet<Item>();
        }
    }

    static class Menu_Color {
        public final String ID = "color_values";
        public final String COMMENT = "Input Prefixes; Decimal[0d, none], Hex[0x, #], Octal[0o, 0], Binary[0b]";
        final ConfigObject<String> white = ConfigObject.of((String)"white", (Object)"0xFFFFFF", validator, (String[])new String[]{"", "color.white"});
        final ConfigObject<String> orange = ConfigObject.of((String)"orange", (Object)"0xDD854B", validator, (String[])new String[]{"", "color.orange"});
        final ConfigObject<String> magenta = ConfigObject.of((String)"magenta", (Object)"0xBD61C5", validator, (String[])new String[]{"", "color.magenta"});
        final ConfigObject<String> light_blue = ConfigObject.of((String)"light_blue", (Object)"0x7E99D0", validator, (String[])new String[]{"", "color.light_blue"});
        final ConfigObject<String> yellow = ConfigObject.of((String)"yellow", (Object)"0xC4B82E", validator, (String[])new String[]{"", "color.yellow"});
        final ConfigObject<String> lime = ConfigObject.of((String)"lime", (Object)"0x49BD3D", validator, (String[])new String[]{"", "color.lime"});
        final ConfigObject<String> pink = ConfigObject.of((String)"pink", (Object)"0xD89AAA", validator, (String[])new String[]{"", "color.pink"});
        final ConfigObject<String> gray = ConfigObject.of((String)"gray", (Object)"0x464646", validator, (String[])new String[]{"", "color.gray"});
        final ConfigObject<String> light_gray = ConfigObject.of((String)"light_gray", (Object)"0xA9AFAF", validator, (String[])new String[]{"", "color.light_gray"});
        final ConfigObject<String> cyan = ConfigObject.of((String)"cyan", (Object)"0x337895", validator, (String[])new String[]{"", "color.cyan"});
        final ConfigObject<String> purple = ConfigObject.of((String)"purple", (Object)"0x8946C2", validator, (String[])new String[]{"", "color.purple"});
        final ConfigObject<String> blue = ConfigObject.of((String)"blue", (Object)"0x323E9A", validator, (String[])new String[]{"", "color.blue"});
        final ConfigObject<String> brown = ConfigObject.of((String)"brown", (Object)"0x563822", validator, (String[])new String[]{"", "color.brown"});
        final ConfigObject<String> green = ConfigObject.of((String)"green", (Object)"0x3A4E1E", validator, (String[])new String[]{"", "color.green"});
        final ConfigObject<String> red = ConfigObject.of((String)"red", (Object)"0xA53A35", validator, (String[])new String[]{"", "color.red"});
        final ConfigObject<String> black = ConfigObject.of((String)"black", (Object)"0x262626", validator, (String[])new String[]{"", "color.black"});
        private static final Predicate<Object> validator = object -> {
            String string;
            if (object instanceof String && !Strings.isNullOrEmpty((String)(string = (String)object))) {
                return ColorHelper.colorFromString((String)string, (Integer)null) != null;
            }
            return false;
        };

        Menu_Color() {
        }
    }

    public static class Menu_Settings {
        public final String ID = "capacity_settings";
        public final String COMMENT = "Adjust Available Storage";
        final ConfigObject<Integer> tankSizeMin = ConfigObject.of((String)"tank_size_min", (Object)32, (Object)4, (Object)128, (String[])new String[0]);
        final ConfigObject<Integer> tankSizeMax = ConfigObject.of((String)"tank_size_max", (Object)256, (Object)4, (Object)512, (String[])new String[0]);
        public final ConfigObject<Integer> smallCapacity = ConfigObject.of((String)"small_capacity_upgrade", (Object)8, (Object)2, (Object)16, (String[])new String[0]);
        public final ConfigObject<Integer> largeCapacity = ConfigObject.of((String)"large_capacity_upgrade", (Object)16, (Object)4, (Object)32, (String[])new String[0]);
        public final ConfigObject<Integer> tankPumpMax = ConfigObject.of((String)"max_pump_upgrades", (Object)4, (Object)0, (Object)8, (String[])new String[0]);
        public final ConfigObject<Boolean> hasStarterPump = ConfigObject.of((String)"tanks_start_with_pump", (Object)true, (String[])new String[0]);
    }

    static class Menu_Upgrade {
        public final String ID = "upgrade_items";
        public final String COMMENT = "List Entry Format <modId>:<item> or tag|<tagId>";
        final ConfigObject<List<? extends String>> convertToPersonal = ConfigObject.of((String)"convert_to_personal", Menu_Upgrade.getListOf("tag|c:gems/diamond"), validator, (String[])new String[0]);
        final ConfigObject<List<? extends String>> convertToTeam = ConfigObject.of((String)"convert_to_team", Menu_Upgrade.getListOf("tag|c:gems/emerald"), validator, (String[])new String[0]);
        final ConfigObject<List<? extends String>> sCapacity_multi = ConfigObject.of((String)"small_capacity", Menu_Upgrade.getListOf("tag|c:ender_pearls"), validator, (String[])new String[0]);
        final ConfigObject<List<? extends String>> lCapacity_multi = ConfigObject.of((String)"large_capacity", Menu_Upgrade.getListOf("minecraft:ender_eye"), validator, (String[])new String[0]);
        final ConfigObject<List<? extends String>> pumpCapacity_multi = ConfigObject.of((String)"pump_capacity", Menu_Upgrade.getListOf("minecraft:piston"), validator, (String[])new String[0]);
        final ConfigObject<List<? extends String>> sCapacity_single = ConfigObject.of((String)"small_capacity_singleuse", Menu_Upgrade.getListOf(new String[0]), validator, (String[])new String[0]);
        final ConfigObject<List<? extends String>> lCapacity_single = ConfigObject.of((String)"large_capacity_singleuse", Menu_Upgrade.getListOf(new String[0]), validator, (String[])new String[0]);
        final ConfigObject<List<? extends String>> pumpCapacity_single = ConfigObject.of((String)"pump_capacity_singleuse", Menu_Upgrade.getListOf(new String[0]), validator, (String[])new String[0]);
        private static final Predicate<Object> validator = object -> {
            if (object instanceof String) {
                String string = (String)object;
                return Strings.isNullOrEmpty((String)string) || string.split(":").length == 2;
            }
            return false;
        };

        Menu_Upgrade() {
        }

        private static List<String> getListOf(String ... values) {
            return values.length == 0 ? Collections.emptyList() : ImmutableList.copyOf((Object[])values);
        }
    }

    public static class Menu_General {
        public final ConfigObject<Integer> lineChangeDelay = ConfigObject.of((String)"info_line_change_delay", (Object)1500, (Object)250, (Object)10000, (String[])new String[0]);
        public final ConfigObject<Boolean> inWorldRecoloring = ConfigObject.of((String)"in_world_coloring", (Object)true, (String[])new String[0]);
        public final ConfigObject<Boolean> fullStackLinking = ConfigObject.of((String)"full_stack_linking", (Object)true, (String[])new String[0]);
    }

    public static class Menu_Access {
        public final String ID = "access_settings";
        public final String COMMENT = "Configure Usability and Interactions";
        public final ConfigObject<Boolean> allowPublicTanks = ConfigObject.of((String)"public_tanks", (Object)true, (String[])new String[0]);
        public final ConfigObject<Boolean> allowPersonalTanks = ConfigObject.of((String)"personal_tanks", (Object)true, (String[])new String[0]);
        public final ConfigObject<Boolean> allowTeamTanks = ConfigObject.of((String)"team_tanks", (Object)true, (String[])new String[0]);
        public final ConfigObject<Boolean> allowPublicBuckets = ConfigObject.of((String)"public_buckets", (Object)true, (String[])new String[0]);
        public final ConfigObject<Boolean> allowPersonalBuckets = ConfigObject.of((String)"personal_buckets", (Object)true, (String[])new String[0]);
        public final ConfigObject<Boolean> allowTeamBuckets = ConfigObject.of((String)"team_buckets", (Object)true, (String[])new String[0]);
        public final ConfigObject<Boolean> enableAutomationPublic = ConfigObject.of((String)"public_automation", (Object)true, (String[])new String[0]);
        public final ConfigObject<Boolean> enableAutomationPersonal = ConfigObject.of((String)"personal_automation", (Object)true, (String[])new String[0]);
        public final ConfigObject<Boolean> enableAutomationTeam = ConfigObject.of((String)"team_automation", (Object)true, (String[])new String[0]);
        public final ConfigObject<Boolean> lockPersonalEdit = ConfigObject.of((String)"personal_edit_lock", (Object)true, (String[])new String[0]);
        public final ConfigObject<Boolean> lockTeamEdit = ConfigObject.of((String)"team_edit_lock", (Object)true, (String[])new String[0]);
        public final ConfigObject<Boolean> lockPersonalLink = ConfigObject.of((String)"personal_link_lock", (Object)true, (String[])new String[0]);
        public final ConfigObject<Boolean> lockTeamLink = ConfigObject.of((String)"team_link_lock", (Object)true, (String[])new String[0]);
        public final ConfigObject<Boolean> lockPersonalUse = ConfigObject.of((String)"personal_use_lock", (Object)false, (String[])new String[0]);
        public final ConfigObject<Boolean> lockTeamUse = ConfigObject.of((String)"team_use_lock", (Object)false, (String[])new String[0]);
    }

    public static class Menu_Integration {
        public final String ID = "integration";
        public final String COMMENT = "Mod integration can be disabled to solve compatibility issues, remove unwanted/unneeded features, etc.";
        public final ConfigObject<Boolean> storeMekanismChemicals = ConfigObject.of((String)"store_mekanism_chemicals", (Object)true, (String[])new String[0]);
    }
}

