/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.item.custom;

import com.lumengrid.oritechthings.api.CrossDimensionalDrone;
import com.lumengrid.oritechthings.block.ModBlocks;
import com.lumengrid.oritechthings.entity.custom.AcceleratorMagneticFieldBlockEntity;
import com.lumengrid.oritechthings.entity.custom.AcceleratorSpeedSensorBlockEntity;
import com.lumengrid.oritechthings.main.ConfigLoader;
import com.lumengrid.oritechthings.main.ModDataComponents;
import com.lumengrid.oritechthings.main.OritechThings;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;
import rearth.oritech.block.entity.interaction.DronePortEntity;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.item.tools.LaserTargetDesignator;

public class AdvancedTargetDesignator
extends LaserTargetDesignator {
    public AdvancedTargetDesignator(Item.Properties settings) {
        super(settings);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        try {
            BlockEntity machineEntity;
            if (context.getLevel().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            boolean crossDimensionEnabled = ConfigLoader.getInstance().dimensionalDroneSettings.enabled();
            if (!crossDimensionEnabled) {
                return super.useOn(context);
            }
            BlockPos clickedPos = context.getClickedPos();
            Level level = context.getLevel();
            Player player = context.getPlayer();
            BlockState clickedBlockState = level.getBlockState(clickedPos);
            if (clickedBlockState.getBlock() instanceof MachineCoreBlock && ((Boolean)clickedBlockState.getValue((Property)MachineCoreBlock.USED)).booleanValue() && (machineEntity = MachineCoreBlock.getControllerEntity((LevelAccessor)level, (BlockPos)clickedPos)) instanceof LaserArmBlockEntity) {
                clickedPos = clickedPos.below();
                clickedBlockState = level.getBlockState(clickedPos);
            }
            BlockEntity clickedEntity = level.getBlockEntity(clickedPos);
            BlockPos targetPos = null;
            ResourceKey targetDimension = null;
            ItemStack itemInHand = context.getItemInHand();
            if (itemInHand.has(ModDataComponents.TARGET_POSITION)) {
                targetPos = (BlockPos)itemInHand.get((DataComponentType)ModDataComponents.TARGET_POSITION.get());
                targetDimension = (ResourceKey)itemInHand.get((DataComponentType)ModDataComponents.TARGET_DIMENSION.get());
            }
            if (clickedBlockState.getBlock().equals(BlockContent.LASER_ARM_BLOCK) && clickedEntity instanceof LaserArmBlockEntity) {
                return this.setTargetFromDesignator(clickedEntity, targetPos, (ResourceKey<Level>)targetDimension, player, (ResourceKey<Level>)level.dimension());
            }
            if (clickedBlockState.getBlock().equals(BlockContent.DRONE_PORT_BLOCK) && clickedEntity instanceof DronePortEntity) {
                return this.setTargetFromDesignator(clickedEntity, targetPos, (ResourceKey<Level>)targetDimension, player, (ResourceKey<Level>)level.dimension());
            }
            if (clickedBlockState.getBlock().equals(ModBlocks.ACCELERATOR_SPEED_SENSOR.get()) && clickedEntity instanceof AcceleratorSpeedSensorBlockEntity) {
                return this.setTargetFromDesignator(clickedEntity, targetPos, (ResourceKey<Level>)targetDimension, player, (ResourceKey<Level>)level.dimension());
            }
            if (clickedBlockState.getBlock().equals(ModBlocks.ACCELERATOR_MAGNETIC_FIELD.get()) && clickedEntity instanceof AcceleratorMagneticFieldBlockEntity) {
                return this.setTargetFromDesignator(clickedEntity, targetPos, (ResourceKey<Level>)targetDimension, player, (ResourceKey<Level>)level.dimension());
            }
            if (clickedBlockState.getBlock().equals(BlockContent.ACCELERATOR_CONTROLLER) && clickedEntity instanceof AcceleratorControllerBlockEntity) {
                itemInHand.set((DataComponentType)ModDataComponents.TARGET_POSITION.get(), (Object)context.getClickedPos());
                itemInHand.set((DataComponentType)ModDataComponents.TARGET_DIMENSION.get(), (Object)level.dimension());
                Objects.requireNonNull(player).sendSystemMessage((Component)Component.translatable((String)"message.oritechthings.advanced_target_designator.accelerator_saved").append((Component)Component.literal((String)context.getClickedPos().toShortString()).withStyle(ChatFormatting.BLUE)));
                return InteractionResult.SUCCESS;
            }
            if (!clickedBlockState.getBlock().equals(Blocks.AIR)) {
                itemInHand.set((DataComponentType)ModDataComponents.TARGET_POSITION.get(), (Object)context.getClickedPos());
                itemInHand.set((DataComponentType)ModDataComponents.TARGET_DIMENSION.get(), (Object)level.dimension());
                Objects.requireNonNull(player).sendSystemMessage((Component)Component.translatable((String)"message.oritech.target_designator.position_stored"));
            }
        }
        catch (Exception e) {
            OritechThings.LOGGER.error("AdvancedTargetDesignator.useOn: {}", (Object)e.getMessage());
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult setTargetFromDesignator(BlockEntity entity, BlockPos targetPos, ResourceKey<Level> targetDimension, Player player, ResourceKey<Level> actualDimension) {
        boolean success = false;
        if (entity instanceof DronePortEntity) {
            DronePortEntity dronePortEntity = (DronePortEntity)entity;
            CrossDimensionalDrone crossDimensionalDrone = (CrossDimensionalDrone)dronePortEntity;
            success = crossDimensionalDrone.oritechthings$setCrossDimensionalTarget(targetPos, targetDimension);
        } else {
            if (targetDimension != actualDimension) {
                Objects.requireNonNull(player).sendSystemMessage((Component)Component.translatable((String)"message.oritechthings.advanced_target_designator.different_dimension"));
                return InteractionResult.FAIL;
            }
            BlockEntity blockEntity = entity;
            Objects.requireNonNull(blockEntity);
            BlockEntity blockEntity2 = blockEntity;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LaserArmBlockEntity.class, AcceleratorSpeedSensorBlockEntity.class, AcceleratorMagneticFieldBlockEntity.class}, (Object)blockEntity2, n)) {
                case 0: {
                    LaserArmBlockEntity laserEntity = (LaserArmBlockEntity)blockEntity2;
                    if (laserEntity.hunterAddons > 0) {
                        laserEntity.cycleHunterTargetMode();
                        player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.target_designator.hunter_target", (Object[])new Object[]{Component.translatable((String)laserEntity.hunterTargetMode.message)}));
                        return InteractionResult.SUCCESS;
                    }
                    success = laserEntity.setTargetFromDesignator(targetPos);
                    break;
                }
                case 1: {
                    AcceleratorSpeedSensorBlockEntity speedSensorEntity = (AcceleratorSpeedSensorBlockEntity)blockEntity2;
                    success = speedSensorEntity.setTargetDesignator(targetPos, player);
                    break;
                }
                case 2: {
                    AcceleratorMagneticFieldBlockEntity magneticFieldEntity = (AcceleratorMagneticFieldBlockEntity)blockEntity2;
                    success = magneticFieldEntity.setTargetDesignator(targetPos, player);
                    break;
                }
            }
        }
        Objects.requireNonNull(player).sendSystemMessage((Component)Component.translatable((String)(success ? "message.oritech.target_designator.position_saved" : "message.oritechthings.advanced_target_designator.position_invalid")));
        return success ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        if (stack.has((DataComponentType)ModDataComponents.TARGET_POSITION.get())) {
            BlockPos data = (BlockPos)stack.get((DataComponentType)ModDataComponents.TARGET_POSITION.get());
            assert (data != null);
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.target_designator.set_to", (Object[])new Object[]{data.toShortString()}));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.target_designator.no_target"));
        }
        if (ConfigLoader.getInstance().dimensionalDroneSettings.enabled()) {
            ResourceKey dimension = (ResourceKey)stack.get((DataComponentType)ModDataComponents.TARGET_DIMENSION.get());
            tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.advanced_target_designator.dimension").append((Component)Component.literal((String)this.getDimensionName((ResourceKey<Level>)dimension)).withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.BOLD)));
        }
        tooltip.add((Component)Component.empty());
        if (Screen.hasControlDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.advanced_target_designator.usage").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.advanced_target_designator.speed_sensor").withStyle(ChatFormatting.BLUE));
            if (ConfigLoader.getInstance().magneticFieldSettings.enabled()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.advanced_target_designator.magnetic_field").withStyle(ChatFormatting.BLUE));
            }
            tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.advanced_target_designator.drone_port").withStyle(ChatFormatting.BLUE));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.advanced_target_designator.laser_arm").withStyle(ChatFormatting.BLUE));
            if (ConfigLoader.getInstance().dimensionalDroneSettings.enabled()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.advanced_target_designator.cross_dimensional").withStyle(ChatFormatting.GOLD));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.item_extra_info").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        }
    }

    private String getDimensionName(ResourceKey<Level> dimensionKey) {
        String path;
        if (dimensionKey == null) {
            return "Unknown";
        }
        ResourceLocation location = dimensionKey.location();
        String namespace = location.getNamespace();
        return " " + (String)(switch (path = location.getPath()) {
            case "overworld" -> "Overworld";
            case "the_nether" -> "Nether";
            case "the_end" -> "End";
            default -> namespace + ":" + path;
        });
    }
}

