/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.entity.custom;

import com.lumengrid.oritechthings.api.MagneticFieldController;
import com.lumengrid.oritechthings.block.custom.AcceleratorMagneticFieldBlock;
import com.lumengrid.oritechthings.entity.ModEntities;
import com.lumengrid.oritechthings.main.ConfigLoader;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.block.blocks.accelerator.AcceleratorControllerBlock;
import rearth.oritech.block.blocks.accelerator.AcceleratorPassthroughBlock;
import rearth.oritech.block.blocks.accelerator.BlackHoleBlock;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;
import rearth.oritech.util.ComparatorOutputProvider;

public class AcceleratorMagneticFieldBlockEntity
extends ExpandableEnergyStorageBlockEntity
implements ComparatorOutputProvider {
    public static final long BASE_ENERGY_CAPACITY = 500000L;
    public static final long BASE_ENERGY_INSERTION = 20000L;
    public static final long BASE_ENERGY_EXTRACTION = 0L;

    public AcceleratorMagneticFieldBlockEntity(BlockPos pos, BlockState state) {
        super(ModEntities.ACCELERATOR_MAGNETIC_FIELD_BLOCK_ENTITY.get(), pos, state);
    }

    public boolean setTargetDesignator(BlockPos acceleratorPos, Player player) {
        if (acceleratorPos == null) {
            player.sendSystemMessage((Component)Component.translatable((String)"block.oritechthings.accelerator_magnetic_field.invalid_controller").withStyle(ChatFormatting.RED));
            return false;
        }
        assert (this.level != null);
        BlockEntity acceleratorEntity = this.level.getBlockEntity(acceleratorPos);
        if (!(acceleratorEntity instanceof AcceleratorControllerBlockEntity)) {
            player.sendSystemMessage((Component)Component.translatable((String)"block.oritechthings.accelerator_magnetic_field.invalid_controller").withStyle(ChatFormatting.RED));
            return false;
        }
        if (!this.isWithinAcceleratorArea(acceleratorPos, this.getBlockPos())) {
            player.sendSystemMessage((Component)Component.translatable((String)"block.oritechthings.accelerator_magnetic_field.outside_area").withStyle(ChatFormatting.RED));
            return false;
        }
        ((MagneticFieldController)acceleratorEntity).addMagneticField(this.getBlockPos());
        this.level.playSound(player, this.getBlockPos(), SoundEvents.ALLAY_AMBIENT_WITH_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
        player.sendSystemMessage((Component)Component.translatable((String)"block.oritechthings.accelerator_magnetic_field.controller_set").append((Component)Component.literal((String)acceleratorPos.toShortString()).withStyle(ChatFormatting.BLUE)));
        this.setChanged();
        return true;
    }

    private boolean isWithinAcceleratorArea(BlockPos acceleratorPos, BlockPos magnetPos) {
        if (magnetPos.getY() != acceleratorPos.getY()) {
            return false;
        }
        ConfigLoader.MagneticField config = ConfigLoader.getInstance().magneticFieldSettings;
        int searchRadius = config.searchRadius();
        int maxAllowedDistance = config.minDistance();
        int minDistance = Integer.MAX_VALUE;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int z = -searchRadius; z <= searchRadius; ++z) {
                BlockPos checkPos = acceleratorPos.offset(x, 0, z);
                assert (this.level != null);
                BlockState blockState = this.level.getBlockState(checkPos);
                Block block = blockState.getBlock();
                if (!this.isAcceleratorComponent(block)) continue;
                int distance = magnetPos.distManhattan((Vec3i)checkPos);
                minDistance = Math.min(minDistance, distance);
            }
        }
        return minDistance <= maxAllowedDistance;
    }

    private boolean isAcceleratorComponent(Block block) {
        if (block instanceof AcceleratorPassthroughBlock) {
            return true;
        }
        if (block instanceof AcceleratorControllerBlock) {
            return true;
        }
        if (block instanceof AcceleratorMagneticFieldBlock) {
            return true;
        }
        return block instanceof BlackHoleBlock;
    }

    public int getComparatorOutput() {
        if (this.energyStorage.amount == 0L) {
            return 0;
        }
        return (int)(1.0f + (float)this.energyStorage.amount / (float)this.energyStorage.capacity * 14.0f);
    }

    public long getDefaultCapacity() {
        return 500000L;
    }

    public long getDefaultInsertRate() {
        return 20000L;
    }

    public long getDefaultExtractionRate() {
        return 0L;
    }

    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 0, -1), new Vec3i(0, 0, 1), new Vec3i(0, -1, 0));
    }

    public float getCoreQuality() {
        return 5.0f;
    }

    public Direction getFacing() {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)AcceleratorMagneticFieldBlock.TARGET_DIR)) {
            return (Direction)state.getValue((Property)AcceleratorMagneticFieldBlock.TARGET_DIR);
        }
        return Direction.NORTH;
    }

    public Direction getFacingForAddon() {
        BlockState state = Objects.requireNonNull(this.level).getBlockState(this.getBlockPos());
        if (state.hasProperty((Property)AcceleratorMagneticFieldBlock.TARGET_DIR)) {
            Direction facing = (Direction)state.getValue((Property)AcceleratorMagneticFieldBlock.TARGET_DIR);
            if (facing.equals((Object)Direction.UP) || facing.equals((Object)Direction.DOWN)) {
                return Direction.NORTH;
            }
            return facing;
        }
        return Direction.NORTH;
    }

    public Property<Direction> getBlockFacingProperty() {
        return AcceleratorMagneticFieldBlock.TARGET_DIR;
    }
}

