/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.datagen;

import com.lumengrid.oritechthings.block.ModBlocks;
import com.lumengrid.oritechthings.block.custom.TierAddonBlock;
import com.lumengrid.oritechthings.util.Constants;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "oritechthings", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (DeferredBlock<?> data : Constants.getAllAddons()) {
            this.addonBlockState(data);
        }
        this.simpleBlockState(ModBlocks.ACCELERATOR_MAGNETIC_FIELD);
        this.simpleBlockState(ModBlocks.ACCELERATOR_SPEED_SENSOR);
        this.blockwithparentModel(ModBlocks.INFESTED_AMETHYST_BLOCK, "block/amethyst_block");
    }

    private void blockWithItem(DeferredBlock<?> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }

    private void blockwithparentModel(DeferredBlock<?> deferredBlock, String parent) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), (ModelFile)this.models().withExistingParent(deferredBlock.getRegisteredName(), this.mcLoc(parent)));
    }

    private void addonBlockState(DeferredBlock<?> deferredBlock) {
        ModelFile model = ModBlockStateProvider.model(deferredBlock);
        this.simpleBlockItem((Block)deferredBlock.get(), model);
        Block block = (Block)deferredBlock.get();
        if (block instanceof TierAddonBlock) {
            VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
            for (boolean addonUsed : new boolean[]{false, true}) {
                for (Direction facing : Direction.values()) {
                    if (!facing.getAxis().isHorizontal()) continue;
                    for (AttachFace face : AttachFace.values()) {
                        variantBuilder.partialState().with((Property)TierAddonBlock.ADDON_USED, (Comparable)Boolean.valueOf(addonUsed)).with((Property)TierAddonBlock.FACING, (Comparable)facing).with((Property)TierAddonBlock.FACE, (Comparable)face).modelForState().modelFile(model).rotationY((int)facing.getOpposite().toYRot()).rotationX(face.ordinal() * 90).addModel();
                    }
                }
            }
        } else {
            this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile(model).rotationY((int)((Direction)state.getValue((Property)TierAddonBlock.FACING)).getOpposite().toYRot()).rotationX(((AttachFace)state.getValue((Property)TierAddonBlock.FACE)).ordinal() * 90).build());
        }
    }

    private void simpleBlockState(DeferredBlock<?> deferredBlock) {
        ModelFile model = ModBlockStateProvider.model(deferredBlock);
        this.simpleBlockItem((Block)deferredBlock.get(), model);
        this.getVariantBuilder((Block)deferredBlock.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(model).build());
    }

    private static ModelFile model(DeferredBlock<?> deferredBlock) {
        ResourceLocation model = ResourceLocation.parse((String)(deferredBlock.getId().getNamespace() + ":block/" + deferredBlock.getId().getPath()));
        return new ModelFile.UncheckedModelFile(model);
    }
}

