/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.client.screen;

import com.lumengrid.oritechthings.client.screen.component.ToggleButton;
import com.lumengrid.oritechthings.menu.AcceleratorSpeedSensorMenu;
import com.lumengrid.oritechthings.network.packet.UpdateSpeedSensorC2SPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;

public class AcceleratorSpeedSensorScreen
extends AbstractContainerScreen<AcceleratorSpeedSensorMenu> {
    private final Component title = Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.title");
    public static ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"oritechthings", (String)"textures/gui/speed_sensor.png");
    private EditBox speedInput;
    private ToggleButton arrowToggle;
    private ToggleButton onOffButton;
    private ToggleButton modeButton;

    public AcceleratorSpeedSensorScreen(AcceleratorSpeedSensorMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 10000;
        this.modeButton = new ToggleButton(this.leftPos + 8, this.topPos + 20, 40, 18, (Component)(((AcceleratorSpeedSensorMenu)this.menu).be.isAutomaticMode() ? Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.auto") : Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.manual")), button -> {
            boolean newState = !((AcceleratorSpeedSensorMenu)this.menu).be.isAutomaticMode();
            ((AcceleratorSpeedSensorMenu)this.menu).be.setAutomaticMode(newState);
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSpeedSensorC2SPacket(((AcceleratorSpeedSensorMenu)this.menu).be.getBlockPos(), ((AcceleratorSpeedSensorMenu)this.menu).be.getSpeedLimit(), ((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled(), ((AcceleratorSpeedSensorMenu)this.menu).be.isCheckGreater(), newState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            button.setMessage((Component)(newState ? Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.auto") : Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.manual")));
            if (button instanceof ToggleButton) {
                ToggleButton toggleBtn = (ToggleButton)button;
                toggleBtn.setToggleState(newState);
                toggleBtn.setColors(newState ? -11893016 : -6710887, newState ? -11893016 : -6710887);
            }
            this.updateTooltips();
            this.updateManualControlsVisibility();
        }, ((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled(), ((AcceleratorSpeedSensorMenu)this.menu).be.isAutomaticMode() ? -11893016 : -6710887, ((AcceleratorSpeedSensorMenu)this.menu).be.isAutomaticMode() ? -11893016 : -6710887);
        this.addRenderableWidget((GuiEventListener)this.modeButton);
        this.onOffButton = new ToggleButton(this.leftPos + 135, this.topPos + 20, 28, 18, (Component)(((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled() ? Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.on") : Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.off")), button -> {
            boolean newState = !((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled();
            ((AcceleratorSpeedSensorMenu)this.menu).be.setEnabled(newState);
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSpeedSensorC2SPacket(((AcceleratorSpeedSensorMenu)this.menu).be.getBlockPos(), ((AcceleratorSpeedSensorMenu)this.menu).be.getSpeedLimit(), newState, ((AcceleratorSpeedSensorMenu)this.menu).be.isCheckGreater(), ((AcceleratorSpeedSensorMenu)this.menu).be.isAutomaticMode()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            button.setMessage((Component)(newState ? Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.on") : Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.off")));
            if (button instanceof ToggleButton) {
                ToggleButton toggleBtn = (ToggleButton)button;
                toggleBtn.setToggleState(newState);
                toggleBtn.setColors(newState ? -11141291 : -43691, newState ? -11141291 : -43691);
            }
            this.updateTooltips();
        }, ((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled(), ((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled() ? -11141291 : -43691, ((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled() ? -11141291 : -43691);
        this.addRenderableWidget((GuiEventListener)this.onOffButton);
        this.arrowToggle = new ToggleButton(this.leftPos + 8, this.topPos + 50, 17, 17, (Component)Component.literal((String)(((AcceleratorSpeedSensorMenu)this.menu).be.isCheckGreater() ? ">" : "<")), button -> {
            boolean newState = !((AcceleratorSpeedSensorMenu)this.menu).be.isCheckGreater();
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSpeedSensorC2SPacket(((AcceleratorSpeedSensorMenu)this.menu).be.getBlockPos(), ((AcceleratorSpeedSensorMenu)this.menu).be.getSpeedLimit(), ((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled(), newState, ((AcceleratorSpeedSensorMenu)this.menu).be.isAutomaticMode()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            button.setMessage((Component)Component.literal((String)(newState ? ">" : "<")));
        }, ((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled(), -16777216, -16777216);
        this.addRenderableWidget((GuiEventListener)this.arrowToggle);
        this.speedInput = new EditBox(this.font, this.leftPos + 28, this.topPos + 50, 60, 18, (Component)Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.speed_input"));
        this.speedInput.setMaxLength(6);
        this.speedInput.setFilter(s -> s.matches("\\d*"));
        this.speedInput.setValue(String.valueOf(((AcceleratorSpeedSensorMenu)this.menu).be.getSpeedLimit()));
        this.speedInput.setResponder(this::onSpeedEntered);
        this.addRenderableWidget((GuiEventListener)this.speedInput);
        this.updateTooltips();
        this.updateManualControlsVisibility();
    }

    private void updateTooltips() {
        if (this.modeButton != null) {
            MutableComponent modeTooltip = ((AcceleratorSpeedSensorMenu)this.menu).be.isAutomaticMode() ? Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.auto.tooltip") : Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.manual.tooltip");
            this.modeButton.setTooltip(Tooltip.create((Component)modeTooltip));
        }
        if (this.onOffButton != null) {
            MutableComponent onOffTooltip = ((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled() ? Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.on.tooltip") : Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.off.tooltip");
            this.onOffButton.setTooltip(Tooltip.create((Component)onOffTooltip));
        }
    }

    private void updateManualControlsVisibility() {
        boolean isAutoMode = ((AcceleratorSpeedSensorMenu)this.menu).be.isAutomaticMode();
        if (this.arrowToggle != null) {
            this.arrowToggle.visible = !isAutoMode;
            boolean bl = this.arrowToggle.active = !isAutoMode;
        }
        if (this.speedInput != null) {
            this.speedInput.setVisible(!isAutoMode);
            this.speedInput.setEditable(!isAutoMode);
        }
    }

    private void onSpeedEntered(String input) {
        try {
            int value = input.isEmpty() ? 0 : Integer.parseInt(input);
            value = Math.max(0, Math.min(value, 999999));
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSpeedSensorC2SPacket(((AcceleratorSpeedSensorMenu)this.menu).be.getBlockPos(), value, ((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled(), ((AcceleratorSpeedSensorMenu)this.menu).be.isCheckGreater(), ((AcceleratorSpeedSensorMenu)this.menu).be.isAutomaticMode()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        catch (NumberFormatException e) {
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSpeedSensorC2SPacket(((AcceleratorSpeedSensorMenu)this.menu).be.getBlockPos(), 0, ((AcceleratorSpeedSensorMenu)this.menu).be.isEnabled(), ((AcceleratorSpeedSensorMenu)this.menu).be.isCheckGreater(), ((AcceleratorSpeedSensorMenu)this.menu).be.isAutomaticMode()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(BACKGROUND, x, y, 0.0f, 0.0f, 176, 166, 256, 256);
        this.renderParticleAcceleratorMessage(guiGraphics);
    }

    private void renderParticleAcceleratorMessage(GuiGraphics guiGraphics) {
        MutableComponent statusText;
        boolean isLinked;
        boolean bl = isLinked = ((AcceleratorSpeedSensorMenu)this.menu).be.getTargetDesignator() != null;
        if (isLinked) {
            BlockPos target = ((AcceleratorSpeedSensorMenu)this.menu).be.getTargetDesignator();
            statusText = Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.linked").append(" " + target.toShortString());
        } else {
            statusText = Component.translatable((String)"gui.oritechthings.particle_accelerator_speed_sensor.not_linked");
        }
        int statusColor = isLinked ? 0x55FF55 : 0xFF5555;
        int statusX = this.leftPos + 8;
        int statusY = this.topPos + 72;
        guiGraphics.drawString(this.font, (Component)statusText, statusX, statusY, statusColor);
    }

    protected void renderLabels(GuiGraphics gui, int mouseX, int mouseY) {
        gui.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0xFFFFFF);
    }
}

