/*
 * Decompiled with CFR 0.152.
 */
package dev.uraneptus.fishermens_trap.common.integration.jei;

import dev.uraneptus.fishermens_trap.FishermensTrap;
import dev.uraneptus.fishermens_trap.common.integration.jei.FishtrapCategory;
import dev.uraneptus.fishermens_trap.common.integration.jei.FishtrapRecipeWrapper;
import dev.uraneptus.fishermens_trap.common.registry.FTRegistries;
import dev.uraneptus.fishermens_trap.common.tags.FTItemTags;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_ID = FishermensTrap.modPrefix("jei_plugin");
    public static final RecipeType<FishtrapRecipeWrapper> FISHTRAP_RECIPE = RecipeType.create((String)"fishermens_trap", (String)"fishtrap_fishing", FishtrapRecipeWrapper.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new FishtrapCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(FISHTRAP_RECIPE, this.addWrappers());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)FTRegistries.FISHTRAP_ITEM.get()), new RecipeType[]{FISHTRAP_RECIPE});
    }

    public List<FishtrapRecipeWrapper> addWrappers() {
        ArrayList<FishtrapRecipeWrapper> list = new ArrayList<FishtrapRecipeWrapper>();
        for (ItemStack item : BuiltInRegistries.ITEM.stream().map(ItemStack::new).toList()) {
            ResourceLocation registryName;
            TagKey outputTag;
            if (!item.is(FTItemTags.FISH_BAIT) || !BuiltInRegistries.ITEM.getTag(outputTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)FishermensTrap.modPrefix("jei_display_results/" + (registryName = BuiltInRegistries.ITEM.getKey((Object)item.getItem())).getNamespace() + "/" + registryName.getPath()))).isPresent()) continue;
            list.add(new FishtrapRecipeWrapper(item, Ingredient.of((TagKey)outputTag)));
        }
        return list;
    }
}

