/*
 * Decompiled with CFR 0.152.
 */
package dev.uraneptus.fishermens_trap.common.integration.jei;

import com.google.common.collect.ImmutableList;
import dev.uraneptus.fishermens_trap.FishermensTrap;
import dev.uraneptus.fishermens_trap.common.blocks.FishtrapBlockEntity;
import dev.uraneptus.fishermens_trap.common.integration.jei.FishtrapRecipeWrapper;
import dev.uraneptus.fishermens_trap.common.integration.jei.JEIPlugin;
import dev.uraneptus.fishermens_trap.common.registry.FTRegistries;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class FishtrapCategory
implements IRecipeCategory<FishtrapRecipeWrapper> {
    private static final ResourceLocation FISHTRAP_LOCATION = FishermensTrap.modPrefix("textures/gui/jei_fishtrap.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title = Component.translatable((String)("fishermens_trap.jei." + this.getUid().getPath()));

    public FishtrapCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(FISHTRAP_LOCATION, 0, 0, 162, 51);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)FTRegistries.FISHTRAP_ITEM.get()));
    }

    public RecipeType<FishtrapRecipeWrapper> getRecipeType() {
        return JEIPlugin.FISHTRAP_RECIPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FishtrapRecipeWrapper recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 74, 1).addItemStack(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 1, 34).addItemStacks(Arrays.stream(recipe.getOutput().getItems()).toList());
    }

    public List<Component> getTooltipStrings(FishtrapRecipeWrapper recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (FishtrapCategory.iconPosition(mouseX, mouseY)) {
            if ((Integer)FishtrapBlockEntity.getMinMaxCounterInts().getSecond() > (Integer)FishtrapBlockEntity.getMinMaxCounterInts().getFirst()) {
                return ImmutableList.of((Object)Component.literal((String)("Items are fished every " + String.valueOf(FishtrapBlockEntity.getMinMaxCounterInts().getFirst()) + "-" + String.valueOf(FishtrapBlockEntity.getMinMaxCounterInts().getSecond()) + " ticks")));
            }
            return ImmutableList.of((Object)Component.literal((String)"Error in Config: Min value must be below Max value").withStyle(ChatFormatting.RED));
        }
        return Collections.emptyList();
    }

    private static boolean iconPosition(double mouseX, double mouseY) {
        int iconPosX = 77;
        int iconPosY = 19;
        int iconHeight = 12;
        int iconWidth = 10;
        return (double)iconPosX <= mouseX && mouseX < (double)(iconPosX + iconWidth) && (double)iconPosY <= mouseY && mouseY < (double)(iconPosY + iconHeight);
    }
}

