/*
 * Decompiled with CFR 0.152.
 */
package dev.uraneptus.fishermens_trap.common.blocks.container;

import dev.uraneptus.fishermens_trap.common.blocks.container.FishtrapBaitSlot;
import dev.uraneptus.fishermens_trap.common.blocks.container.FishtrapCollectSlot;
import dev.uraneptus.fishermens_trap.common.registry.FTRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class FishtrapMenu
extends AbstractContainerMenu {
    public final Container container;
    private final ContainerLevelAccess access;

    public FishtrapMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, ContainerLevelAccess.NULL, (Container)new SimpleContainer(10));
    }

    public FishtrapMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess, Container container) {
        super(FTRegistries.FISHTRAP_MENU.get(), pContainerId);
        int i1;
        this.container = container;
        this.access = pAccess;
        FishtrapMenu.checkContainerSize((Container)container, (int)10);
        this.addSlot(new FishtrapBaitSlot(container, 0, 81, 15));
        for (i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new FishtrapCollectSlot(container, i1 + 1, 8 + i1 * 18, 48));
        }
        for (int l = 0; l < 3; ++l) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)pPlayerInventory, k + l * 9 + 9, 8 + k * 18, l * 18 + 84));
            }
        }
        for (i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)pPlayerInventory, i1, 8 + i1 * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (pIndex < this.container.getContainerSize() ? !this.moveItemStackTo(itemstack1, this.container.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.container.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player pPlayer) {
        return FishtrapMenu.stillValid((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)FTRegistries.FISHTRAP_BLOCK.get()));
    }
}

