/*
 * Decompiled with CFR 0.152.
 */
package dev.uraneptus.fishermens_trap.common.blocks;

import dev.uraneptus.fishermens_trap.FishermensTrap;
import dev.uraneptus.fishermens_trap.common.tags.FTItemTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class FishtrapFillingBehavior {
    public static void handleItemInsertion(Container container, List<ItemStack> list, ItemStack baitItem, RandomSource random) {
        for (ItemStack itemStack : list) {
            if (itemStack.isEmpty()) continue;
            FishtrapFillingBehavior.fillFishtrap(container, itemStack, baitItem, random, FishermensTrap.CONFIG.fullStackCatch());
        }
    }

    private static ItemStack fillFishtrap(Container container, ItemStack stack, ItemStack baitItem, RandomSource random, boolean stacked) {
        boolean catchBucketFish;
        if (container == null || stack.isEmpty()) {
            return stack;
        }
        ArrayList<Integer> bucketSlots = new ArrayList<Integer>();
        for (int i = 1; i < container.getContainerSize(); ++i) {
            if (!container.getItem(i).is(Items.WATER_BUCKET)) continue;
            bucketSlots.add(i);
        }
        if (!stacked || !stack.isStackable()) {
            return FishtrapFillingBehavior.insertNonStacked(container, stack, baitItem, random, bucketSlots);
        }
        int sizeInventory = container.getContainerSize();
        boolean bl = catchBucketFish = (double)random.nextFloat() < FishermensTrap.CONFIG.fishBucketChance();
        if (bucketSlots.isEmpty() || !catchBucketFish) {
            for (int i = 1; i < sizeInventory; ++i) {
                ItemStack slot = container.getItem(i);
                if (!ItemStack.isSameItemSameComponents((ItemStack)slot, (ItemStack)stack)) continue;
                stack = FishtrapFillingBehavior.insertItem(container, i, stack);
                baitItem.shrink(1);
                if (stack.isEmpty()) break;
            }
            if (!stack.isEmpty()) {
                FishtrapFillingBehavior.iterateAndAdd(container, stack, baitItem);
            }
        } else {
            stack = FishtrapFillingBehavior.fishWithBucket(container, stack, baitItem, random, bucketSlots);
        }
        return stack;
    }

    private static ItemStack insertNonStacked(Container container, ItemStack stack, ItemStack baitItem, RandomSource random, List<Integer> bucketSlots) {
        boolean catchBucketFish;
        if (container == null || stack.isEmpty()) {
            return stack;
        }
        boolean emptySlotsLeft = false;
        for (int i = 1; i < container.getContainerSize(); ++i) {
            if (!container.getItem(i).isEmpty()) continue;
            emptySlotsLeft = true;
            break;
        }
        if (!emptySlotsLeft && bucketSlots.isEmpty()) {
            return stack;
        }
        boolean bl = catchBucketFish = (double)random.nextFloat() < FishermensTrap.CONFIG.fishBucketChance() || !emptySlotsLeft;
        if (bucketSlots.isEmpty() || !catchBucketFish) {
            FishtrapFillingBehavior.iterateAndAdd(container, stack, baitItem);
        } else {
            stack = FishtrapFillingBehavior.fishWithBucket(container, stack, baitItem, random, bucketSlots);
        }
        return stack;
    }

    private static ItemStack fishWithBucket(Container container, ItemStack stack, ItemStack baitItem, RandomSource random, List<Integer> bucketSlots) {
        int selectedSlot = bucketSlots.get(random.nextInt(bucketSlots.size()));
        ItemStack bucket = container.getItem(selectedSlot);
        ResourceLocation regName = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        ResourceLocation bucketFishLocation = ResourceLocation.fromNamespaceAndPath((String)Objects.requireNonNull(regName).getNamespace(), (String)(regName.getPath() + "_bucket"));
        if (BuiltInRegistries.ITEM.containsKey(bucketFishLocation)) {
            bucket.shrink(1);
            stack = FishtrapFillingBehavior.insertItem(container, selectedSlot, Objects.requireNonNull((Item)BuiltInRegistries.ITEM.get(bucketFishLocation)).getDefaultInstance());
            baitItem.shrink(1);
        }
        return stack;
    }

    private static ItemStack iterateAndAdd(Container container, ItemStack stack, ItemStack baitItem) {
        for (int i = 1; i < container.getContainerSize(); ++i) {
            if (!container.getItem(i).isEmpty()) continue;
            baitItem.shrink(1);
            stack = FishtrapFillingBehavior.insertItem(container, i, stack);
            if (stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private static ItemStack insertItem(Container container, int slot, ItemStack stack) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!FishtrapFillingBehavior.isItemValid(slot, stack)) {
            return stack;
        }
        if (slot < 0 || slot >= container.getContainerSize()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + container.getContainerSize() + ")");
        }
        ItemStack existing = container.getItem(slot);
        int limit = FishtrapFillingBehavior.getCollectStackLimit(slot, stack);
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (existing.isEmpty()) {
            container.setItem(slot, reachedLimit ? stack.copyWithCount(limit) : stack);
        } else {
            existing.grow(reachedLimit ? limit : stack.getCount());
        }
        return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
    }

    private static boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (slot == 0) {
            return stack.is(FTItemTags.FISH_BAIT);
        }
        return true;
    }

    private static int getCollectStackLimit(int slot, ItemStack stack) {
        return slot != 0 && !FishermensTrap.CONFIG.fullStackCatch() ? 1 : stack.getMaxStackSize();
    }
}

