/*
 * Decompiled with CFR 0.152.
 */
package dev.uraneptus.fishermens_trap.common.blocks;

import com.mojang.datafixers.util.Pair;
import dev.uraneptus.fishermens_trap.FishermensTrap;
import dev.uraneptus.fishermens_trap.common.blocks.FishtrapFillingBehavior;
import dev.uraneptus.fishermens_trap.common.blocks.container.FishtrapMenu;
import dev.uraneptus.fishermens_trap.common.registry.FTRegistries;
import dev.uraneptus.fishermens_trap.common.tags.FTBiomeTags;
import dev.uraneptus.fishermens_trap.common.tags.FTItemTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.Nullable;

public class FishtrapBlockEntity
extends RandomizableContainerBlockEntity {
    public static final Component FISHTRAP_NAME = Component.translatable((String)"fishermens_trap.container.fishtrap");
    private NonNullList<ItemStack> items = NonNullList.withSize((int)10, (Object)ItemStack.EMPTY);
    private int tickCounter = 0;

    public FishtrapBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(FTRegistries.FISHTRAP_BE.get(), pPos, pBlockState);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        if (!this.trySaveLootTable(pTag)) {
            ContainerHelper.saveAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        }
        pTag.putInt("tickCounter", this.tickCounter);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(pTag)) {
            ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        }
        this.tickCounter = pTag.getInt("tickCounter");
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public ItemStack removeItem(int slot, int amount) {
        this.unpackLootTable(null);
        return ContainerHelper.removeItem(this.getItems(), (int)slot, (int)amount);
    }

    public void setItem(int slot, ItemStack stack) {
        this.unpackLootTable(null);
        this.getItems().set(slot, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
    }

    protected Component getDefaultName() {
        return FISHTRAP_NAME;
    }

    private CompoundTag saveItems(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.items, (HolderLookup.Provider)pRegistries);
        }
        return compound;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveItems(new CompoundTag(), pRegistries);
    }

    public static Pair<Integer, Integer> getMinMaxCounterInts() {
        if (FishermensTrap.ABSTRACTIONS.isDevEnvironment()) {
            return Pair.of((Object)48, (Object)80);
        }
        return Pair.of((Object)FishermensTrap.CONFIG.minTicksToFish(), (Object)FishermensTrap.CONFIG.maxTicksToFish());
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, FishtrapBlockEntity pBlockEntity) {
        RandomSource random = pLevel.getRandom();
        if ((Integer)FishtrapBlockEntity.getMinMaxCounterInts().getSecond() > (Integer)FishtrapBlockEntity.getMinMaxCounterInts().getFirst()) {
            if (pBlockEntity.tickCounter >= random.nextIntBetweenInclusive(((Integer)FishtrapBlockEntity.getMinMaxCounterInts().getFirst()).intValue(), ((Integer)FishtrapBlockEntity.getMinMaxCounterInts().getSecond()).intValue())) {
                pBlockEntity.tickCounter = 0;
                if (FishtrapBlockEntity.isValidFishingLocation(pLevel, pPos)) {
                    LootTable loottable;
                    LootParams lootparams = new LootParams.Builder((ServerLevel)pLevel).create(LootContextParamSets.EMPTY);
                    ItemStack itemInBaitSlot = pBlockEntity.getItem(0);
                    if (itemInBaitSlot.is(FTItemTags.FISH_BAIT) && !itemInBaitSlot.is(Items.AIR)) {
                        ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)itemInBaitSlot.getItem());
                        ResourceLocation lootTableLocation = FishermensTrap.modPrefix("gameplay/fishtrap_fishing/" + Objects.requireNonNull(registryName).getNamespace() + "/" + registryName.getPath());
                        loottable = pLevel.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTableLocation));
                    } else {
                        loottable = pLevel.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.FISHING_JUNK);
                    }
                    ObjectArrayList list = loottable.getRandomItems(lootparams);
                    list.forEach(arg_0 -> FishtrapBlockEntity.lambda$serverTick$0((List)list, arg_0));
                    FishtrapFillingBehavior.handleItemInsertion((Container)pBlockEntity, (List<ItemStack>)list, itemInBaitSlot, random);
                }
            } else {
                ++pBlockEntity.tickCounter;
            }
        } else {
            FishermensTrap.LOGGER.error("Fish trap ticks: [Min value must be below Max value]");
        }
    }

    private static boolean isValidFishingLocation(Level pLevel, BlockPos pPos) {
        for (Direction direction : Direction.values()) {
            if (!pLevel.getBlockState(pPos).getFluidState().is(FluidTags.WATER) || !pLevel.getFluidState(pPos.relative(direction)).is(FluidTags.WATER) || !pLevel.getBiome(pPos).is(FTBiomeTags.CAN_FISHTRAP_FISH)) continue;
            return true;
        }
        return false;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return slot == 0 && stack.is(FTItemTags.FISH_BAIT) || stack.is(Items.WATER_BUCKET);
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        return slot != 0 && !stack.is(Items.WATER_BUCKET);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new FishtrapMenu(containerId, inventory, ContainerLevelAccess.NULL, (Container)this);
    }

    private static /* synthetic */ void lambda$serverTick$0(List list, ItemStack item) {
        String name = BuiltInRegistries.ITEM.getKey((Object)item.getItem()).getPath();
        if (name.contains("_slice")) {
            list.remove(item);
        }
    }
}

