/*
 * Decompiled with CFR 0.152.
 */
package dev.uraneptus.fishermens_trap.common.blocks;

import com.mojang.serialization.MapCodec;
import dev.uraneptus.fishermens_trap.common.blocks.FishtrapBlockEntity;
import dev.uraneptus.fishermens_trap.common.registry.FTRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FishtrapBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<FishtrapBlock> CODEC = FishtrapBlock.simpleCodec(FishtrapBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty HANGING = BlockStateProperties.HANGING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public FishtrapBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HANGING, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity tileEntity;
        if (!level.isClientSide && (tileEntity = level.getBlockEntity(pos)) instanceof FishtrapBlockEntity) {
            FishtrapBlockEntity fishtrapBlockEntity = (FishtrapBlockEntity)tileEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu((MenuProvider)fishtrapBlockEntity);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.is(pNewState.getBlock())) {
            BlockEntity blockentity = pLevel.getBlockEntity(pPos);
            if (blockentity instanceof FishtrapBlockEntity) {
                FishtrapBlockEntity fishtrapBlockEntity = (FishtrapBlockEntity)blockentity;
                Containers.dropContents((Level)pLevel, (BlockPos)pPos, fishtrapBlockEntity.getItems());
                pLevel.updateNeighbourForOutputSignal(pPos, (Block)this);
            }
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            return Block.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)10.0, (double)13.0);
        }
        return Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)10.0, (double)16.0);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState stateAbove = pContext.getLevel().getBlockState(pContext.getClickedPos().above());
        Direction direction = pContext.getHorizontalDirection().getOpposite();
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        boolean hangingFlag = !stateAbove.isAir() && !stateAbove.is(Blocks.WATER) && !stateAbove.is(Blocks.LAVA);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.is((Fluid)Fluids.WATER)))).setValue((Property)HANGING, (Comparable)Boolean.valueOf(hangingFlag));
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        BlockState stateAbove = pLevel.getBlockState(pCurrentPos.above());
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        if (!(stateAbove.isAir() || stateAbove.is(Blocks.WATER) || stateAbove.is(Blocks.LAVA))) {
            return (BlockState)pState.setValue((Property)HANGING, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos).setValue((Property)HANGING, (Comparable)Boolean.valueOf(false));
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, HANGING, WATERLOGGED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new FishtrapBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        return level.isClientSide ? null : FishtrapBlock.createTickerHelper(blockEntity, FTRegistries.FISHTRAP_BE.get(), FishtrapBlockEntity::serverTick);
    }
}

