/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf;

import net.neoforged.bus.EventBus;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.IEventBus;
import org.zeith.hammerlib.util.java.ReflectionUtil;

public class BusHelper {
    public static EnumEventState postSafe(IEventBus bus, Event evt) {
        try {
            return BusHelper.post(bus, evt);
        }
        catch (Throwable err) {
            err.printStackTrace();
            return EnumEventState.ERRORED;
        }
    }

    public static EnumEventState post(IEventBus bus, Event evt) {
        ICancellableEvent e;
        Event event = bus.post(evt);
        return event instanceof ICancellableEvent && (e = (ICancellableEvent)event).isCanceled() ? EnumEventState.CLOSED : EnumEventState.DISPATCHED;
    }

    public static void setShutdownState(IEventBus bus, boolean shutdown) {
        try {
            ReflectionUtil.lookupField(EventBus.class, "shutdown").setBoolean(bus, shutdown);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static enum EnumEventState {
        CLOSED,
        DISPATCHED,
        ERRORED,
        UNHANDLED;


        public boolean isClosed() {
            return this == CLOSED;
        }

        public boolean isOpen() {
            return this == DISPATCHED;
        }

        public boolean hasErrored() {
            return this == ERRORED;
        }
    }
}

