/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured;

import java.util.Locale;
import java.util.Objects;
import org.zeith.hammerlib.util.configured.ConfiguredLib;
import org.zeith.hammerlib.util.configured.io.IElementFactory;
import org.zeith.hammerlib.util.configured.types.ConfigArray;
import org.zeith.hammerlib.util.configured.types.ConfigElement;

public class ConfigToken<E extends ConfigElement<E>> {
    private final String prefix;
    private final Class<E> type;
    private final IElementFactory<E> factory;

    public ConfigToken(String prefix, Class<E> type, IElementFactory<E> factory) {
        this.prefix = prefix;
        this.type = type;
        this.factory = factory;
        ConfiguredLib.TOKEN_REGISTRY_BY_PREFIX.put(prefix.toLowerCase(Locale.ROOT), this);
    }

    public boolean is(ConfigElement<?> elem) {
        return this.type.isInstance(elem);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Class<E> getType() {
        return this.type;
    }

    public E create(Runnable onChange, String name) {
        return this.factory.create(onChange, this, name);
    }

    public ConfigToken<ConfigArray<E>> arrayOf() {
        Class<ConfigArray> arrayType = ConfigArray.class;
        return new ConfigToken<ConfigArray<E>>("[" + this.getPrefix(), arrayType, (onChanged, token, name) -> new ConfigArray(onChanged, token, this, name));
    }

    public String toString() {
        return "ConfigToken{prefix='" + this.prefix + "', type=" + String.valueOf(this.type) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigToken that = (ConfigToken)o;
        return this.prefix.equals(that.prefix) && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.type);
    }
}

