/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles.tooltip.own.inf;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.zeith.hammerlib.client.utils.RenderUtils;
import org.zeith.hammerlib.tiles.tooltip.own.IRenderableInfo;

public record TooltipInfoStack(ItemStack stack, float width, float height) implements IRenderableInfo
{
    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics matrix, float x, float y, DeltaTracker partialTime) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        PoseStack pose = matrix.pose();
        pose.pushPose();
        pose.translate(x, y, 0.0f);
        pose.scale(this.width / 16.0f, this.height / 16.0f, 1.0f);
        RenderUtils.renderItemIntoGui(pose, this.stack, 0.0f, 0.0f);
        pose.popPose();
    }
}

