/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.zeith.hammerlib.api.LanguageHelper;
import org.zeith.hammerlib.api.lighting.ColoredLight;
import org.zeith.hammerlib.api.proxy.IProxy;

public class HLCommonProxy
implements IProxy {
    protected List<QueuedTask> serverTickTasks = new ArrayList<QueuedTask>();
    private boolean finishedLoading;

    public HLCommonProxy() {
        NeoForge.EVENT_BUS.addListener(this::serverTick);
        NeoForge.EVENT_BUS.addListener(this::serverStopping);
    }

    public void queueTask(Level level, int delay, Runnable task) {
        if (!level.isClientSide) {
            this.serverTickTasks.add(new QueuedTask(delay, task));
        }
    }

    private void serverTick(ServerTickEvent.Pre e) {
        for (int i = 0; i < this.serverTickTasks.size(); ++i) {
            if (!this.serverTickTasks.get(i).shouldRemove()) continue;
            this.serverTickTasks.remove(i);
            --i;
        }
    }

    private void serverStopping(ServerStoppingEvent e) {
        this.serverTickTasks.clear();
    }

    public void construct(IEventBus modBus) {
    }

    public void commonSetup() {
    }

    public void clientSetup() {
    }

    public void applyLang(LanguageHelper.LangMap map) {
    }

    public String getLanguage() {
        return "en_us";
    }

    public String getLanguage(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer ent = (ServerPlayer)player;
            return ent.getLanguage();
        }
        return this.getLanguage();
    }

    @Override
    public Player getClientPlayer() {
        return null;
    }

    public ReloadableResourceManager getResourceManager() {
        MinecraftServer serv = ServerLifecycleHooks.getCurrentServer();
        if (serv != null) {
            return (ReloadableResourceManager)serv.getServerResources().resourceManager();
        }
        return null;
    }

    public Stream<ColoredLight> getGlowingParticles(float partialTicks) {
        return Stream.empty();
    }

    public void finishLoading() {
        this.finishedLoading = true;
    }

    public boolean hasFinishedLoading() {
        return this.finishedLoading;
    }

    public Consumer<FMLClientSetupEvent> addTESR(BlockEntityType<?> type, Class<?> anyTesr) {
        return null;
    }

    public Consumer<RegisterParticleProvidersEvent> addParticleTypeProvider(ParticleType<?> type, Class<?> providerCls) {
        return null;
    }

    protected static final class QueuedTask {
        private int ticksBeforeExecution;
        private Runnable task;

        public QueuedTask(int ticksBeforeExecution, Runnable task) {
            this.ticksBeforeExecution = ticksBeforeExecution;
            this.task = task;
        }

        public boolean shouldRemove() {
            if (--this.ticksBeforeExecution <= 0) {
                if (this.task != null) {
                    this.task.run();
                }
                this.task = null;
                return true;
            }
            return false;
        }
    }
}

