/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.proxy;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Either;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.forge.ContainerAPI;
import org.zeith.hammerlib.api.inv.IScreenContainer;
import org.zeith.hammerlib.api.items.tooltip.TooltipColoredLine;
import org.zeith.hammerlib.api.items.tooltip.TooltipMulti;
import org.zeith.hammerlib.api.lighting.ColoredLight;
import org.zeith.hammerlib.api.lighting.HandleLightOverrideEvent;
import org.zeith.hammerlib.api.lighting.impl.IGlowingEntity;
import org.zeith.hammerlib.api.proxy.IClientProxy;
import org.zeith.hammerlib.client.adapter.ChatMessageAdapter;
import org.zeith.hammerlib.client.model.SimpleModelGenerator;
import org.zeith.hammerlib.client.render.tile.IBESR;
import org.zeith.hammerlib.client.render.tile.TESRBase;
import org.zeith.hammerlib.client.utils.TexturePixelGetter;
import org.zeith.hammerlib.core.adapter.ConfigAdapter;
import org.zeith.hammerlib.core.items.tooltip.ClientTooltipColoredLine;
import org.zeith.hammerlib.core.items.tooltip.ClientTooltipMulti;
import org.zeith.hammerlib.event.client.ClientLoadedInEvent;
import org.zeith.hammerlib.mixins.client.ParticleEngineAccessor;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.packets.PacketPlayerReady;
import org.zeith.hammerlib.net.packets.PingServerPacket;
import org.zeith.hammerlib.proxy.HLCommonProxy;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.mcf.LogicalSidePredictor;

public class HLClientProxy
extends HLCommonProxy
implements IClientProxy {
    protected List<HLCommonProxy.QueuedTask> clientTickTasks = new ArrayList<HLCommonProxy.QueuedTask>();
    public static final KeyMapping RENDER_GUI_ITEM = new KeyMapping("key.hammerlib.render_item", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "key.categories.ui");
    public static Map<ParticleRenderType, Queue<Particle>> PARTICLE_MAP;
    int pingTimer;
    boolean renderedWorld = false;

    public HLClientProxy() {
        NeoForge.EVENT_BUS.addListener(this::clientTick);
    }

    @Override
    public void queueTask(Level level, int delay, Runnable task) {
        super.queueTask(level, delay, task);
        if (level.isClientSide) {
            this.clientTickTasks.add(new HLCommonProxy.QueuedTask(delay, task));
        }
    }

    @Override
    public void construct(IEventBus modBus) {
        modBus.addListener(this::registerKeybinds);
        modBus.addListener(this::modelBake);
        modBus.addListener(this::registerClientTooltips);
        modBus.addListener(this::loadComplete);
        modBus.addListener(this::registerGuis);
        modBus.addListener(TexturePixelGetter::reloadTexture);
        SimpleModelGenerator.setup();
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void loadComplete(FMLLoadCompleteEvent e) {
    }

    private void alterTooltip(RenderTooltipEvent.GatherComponents e) {
        int[] colors = TexturePixelGetter.getAllColors(e.getItemStack());
        e.getTooltipElements().add(Either.right((Object)new TooltipColoredLine(colors)));
    }

    private void registerClientTooltips(RegisterClientTooltipComponentFactoriesEvent e) {
        e.register(TooltipMulti.class, ClientTooltipMulti::new);
        e.register(TooltipColoredLine.class, ClientTooltipColoredLine::new);
    }

    private void registerKeybinds(RegisterKeyMappingsEvent e) {
        e.register(RENDER_GUI_ITEM);
    }

    private void modelBake(ModelEvent.BakingCompleted e) {
    }

    public void registerGuis(RegisterMenuScreensEvent e) {
        e.register(ContainerAPI.TILE_CONTAINER, (ctr, inv, txt) -> Cast.optionally(ctr, IScreenContainer.class).map(c -> c.openScreen(inv, txt)).orElse(null));
    }

    @Override
    public void clientSetup() {
        PARTICLE_MAP = ((ParticleEngineAccessor)Minecraft.getInstance().particleEngine).getParticles();
    }

    public static Stream<Particle> streamParticles() {
        return PARTICLE_MAP.values().stream().flatMap(Collection::stream);
    }

    @Override
    public Stream<ColoredLight> getGlowingParticles(float partialTicks) {
        return HLClientProxy.streamParticles().map(particle -> {
            ColoredLight l = null;
            IGlowingEntity ent = Cast.cast(Float.valueOf(partialTicks), IGlowingEntity.class);
            if (ent != null) {
                l = ent.produceColoredLight(partialTicks);
            }
            HandleLightOverrideEvent evt = new HandleLightOverrideEvent(particle, partialTicks, l);
            HammerLib.postEvent(evt);
            return evt.getNewLight();
        }).filter(Objects::nonNull);
    }

    @Override
    public Consumer<FMLClientSetupEvent> addTESR(BlockEntityType<?> type, Class<?> anyTesr) {
        return e -> {
            ResourceLocation name = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)type);
            if (name == null) {
                HammerLib.LOG.info("Skipping TESR for tile " + String.valueOf(type) + " as it is not registered.");
                return;
            }
            HammerLib.LOG.info("Registering TESR for tile " + String.valueOf(name));
            Function<BlockEntityRendererProvider.Context, BlockEntityRenderer> theTesr = null;
            if (IBESR.class.isAssignableFrom(anyTesr)) {
                try {
                    Constructor ctor = anyTesr.getDeclaredConstructor(new Class[0]);
                    ctor.setAccessible(true);
                    TESRBase base = new TESRBase((IBESR)ctor.newInstance(new Object[0]));
                    theTesr = ctx -> base;
                }
                catch (ReflectiveOperationException err) {
                    throw new ReportedException(new CrashReport("Unable to create IBESR(no-args) for BlockEntityType " + String.valueOf(name), (Throwable)err));
                }
            }
            if (theTesr == null) {
                for (Constructor<?> ctr : anyTesr.getDeclaredConstructors()) {
                    try {
                        if (ctr.getParameterCount() == 0) {
                            BlockEntityRenderer r = (BlockEntityRenderer)ctr.newInstance(new Object[0]);
                            theTesr = c -> r;
                            continue;
                        }
                        if (ctr.getParameterCount() != 1 || ctr.getParameterTypes()[0] != BlockEntityRendererProvider.Context.class) continue;
                        theTesr = ctx -> {
                            try {
                                return (BlockEntityRenderer)Cast.cast(ctr.newInstance(ctx));
                            }
                            catch (ReflectiveOperationException err) {
                                throw new ReportedException(new CrashReport("Unable to create BlockEntityRenderer(no-args) for BlockEntityType " + String.valueOf(name), (Throwable)err));
                            }
                        };
                    }
                    catch (ReflectiveOperationException err) {
                        throw new ReportedException(new CrashReport("Unable to create BlockEntityRenderer(no-args) for BlockEntityType " + String.valueOf(name), (Throwable)err));
                    }
                }
            }
            if (theTesr == null) {
                throw new RuntimeException("Unable to find a valid constructor for " + String.valueOf(name) + "'s TESR " + String.valueOf(anyTesr));
            }
            Function<BlockEntityRendererProvider.Context, BlockEntityRenderer> finalTheTesr = theTesr;
            BlockEntityRenderers.register((BlockEntityType)type, ctx -> (BlockEntityRenderer)Cast.cast(finalTheTesr.apply(ctx)));
        };
    }

    @Override
    public Consumer<RegisterParticleProvidersEvent> addParticleTypeProvider(ParticleType<?> type, Class<?> providerCls) {
        return e -> {
            Constructor<?>[] ctors;
            ResourceLocation name = BuiltInRegistries.PARTICLE_TYPE.getKey((Object)type);
            if (name == null) {
                HammerLib.LOG.info("Skipping Particles for particle type " + String.valueOf(type) + " as it is not registered.");
                return;
            }
            HammerLib.LOG.info("Registering ParticleProvider for particle type " + String.valueOf(name));
            if (ParticleProvider.Sprite.class.isAssignableFrom(providerCls)) {
                try {
                    Constructor<ParticleProvider.Sprite> spc = providerCls.asSubclass(ParticleProvider.Sprite.class).getDeclaredConstructor(new Class[0]);
                    spc.setAccessible(true);
                    e.registerSprite(type, spc.newInstance(new Object[0]));
                    return;
                }
                catch (ReflectiveOperationException ex) {
                    throw new ReportedException(new CrashReport("Unable to create ParticleProvider.Sprite(no-args) for ParticleType " + String.valueOf(name), (Throwable)ex));
                }
            }
            if (ParticleEngine.SpriteParticleRegistration.class.isAssignableFrom(providerCls)) {
                try {
                    Constructor<ParticleEngine.SpriteParticleRegistration> spc = providerCls.asSubclass(ParticleEngine.SpriteParticleRegistration.class).getDeclaredConstructor(new Class[0]);
                    spc.setAccessible(true);
                    e.registerSpriteSet(type, spc.newInstance(new Object[0]));
                    return;
                }
                catch (ReflectiveOperationException ex) {
                    throw new ReportedException(new CrashReport("Unable to create ParticleProvider.Sprite(no-args) for ParticleType " + String.valueOf(name), (Throwable)ex));
                }
            }
            for (Constructor<?> ctor : ctors = providerCls.getConstructors()) {
                if (ctor.getParameterCount() == 0) {
                    ctor.setAccessible(true);
                    try {
                        e.registerSpecial(type, (ParticleProvider)Cast.cast(ctor.newInstance(new Object[0])));
                    }
                    catch (ReflectiveOperationException ex) {
                        throw new ReportedException(new CrashReport("Unable to create ParticleProvider(no-args) for ParticleType " + String.valueOf(name), (Throwable)ex));
                    }
                    return;
                }
                if (ctor.getParameterCount() != 1 || !SpriteSet.class.isAssignableFrom(ctor.getParameterTypes()[0])) continue;
                ctor.setAccessible(true);
                e.registerSpriteSet(type, set -> {
                    try {
                        return (ParticleProvider)Cast.cast(ctor.newInstance(set));
                    }
                    catch (ReflectiveOperationException ex) {
                        throw new ReportedException(new CrashReport("Unable to create ParticleProvider(no-args) for ParticleType " + String.valueOf(name), (Throwable)ex));
                    }
                });
                return;
            }
        };
    }

    @SubscribeEvent
    public void renderWorldLast(RenderLevelStageEvent e) {
        if (!this.renderedWorld) {
            Network.sendToServer(new PacketPlayerReady());
            HammerLib.postNeoEvent(new ClientLoadedInEvent());
            this.renderedWorld = true;
        }
    }

    private void clientTick(ClientTickEvent.Pre e) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            Component c;
            while ((c = ChatMessageAdapter.clientTick()) != null) {
                mc.chatListener.handleSystemMessage(c, false);
            }
        }
        if (mc.level != null) {
            if (!mc.isPaused()) {
                --this.pingTimer;
                if (this.pingTimer <= 0) {
                    this.pingTimer += 40;
                    Network.sendToServer(new PingServerPacket(System.currentTimeMillis()));
                }
            }
        } else if (this.renderedWorld) {
            this.renderedWorld = false;
            ConfigAdapter.resetClientsideSync();
        }
        if (mc.level == null) {
            this.clientTickTasks.clear();
        }
        for (int i = 0; i < this.clientTickTasks.size(); ++i) {
            if (!this.clientTickTasks.get(i).shouldRemove()) continue;
            this.clientTickTasks.remove(i);
            --i;
        }
    }

    @SubscribeEvent
    public void addF3Info(CustomizeGuiOverlayEvent.DebugText f3) {
        List tip = f3.getLeft();
        tip.add(String.valueOf(ChatFormatting.GOLD) + "[HammerLib]" + String.valueOf(ChatFormatting.RESET) + " Ping: ~" + PingServerPacket.lastPingTime + " ms.");
    }

    @Override
    public String getLanguage() {
        return Minecraft.getInstance().options.languageCode;
    }

    @Override
    public Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    @Override
    public ReloadableResourceManager getResourceManager() {
        if (LogicalSidePredictor.getCurrentLogicalSide() == LogicalSide.CLIENT) {
            return (ReloadableResourceManager)Minecraft.getInstance().getResourceManager();
        }
        return super.getResourceManager();
    }
}

