/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.packets;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;

@MainThreaded
public class SyncTileEntityPacket
implements IPacket {
    BlockPos pos;
    CompoundTag nbt;
    boolean updateTag;

    public SyncTileEntityPacket() {
    }

    public SyncTileEntityPacket(BlockEntity tile, boolean updateTag) {
        this.pos = tile.getBlockPos();
        RegistryAccess provider = tile.getLevel().registryAccess();
        this.nbt = updateTag ? tile.getUpdateTag((HolderLookup.Provider)provider) : tile.saveWithFullMetadata((HolderLookup.Provider)provider);
        this.updateTag = updateTag;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeNbt((Tag)this.nbt);
        buf.writeBoolean(this.updateTag);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.nbt = buf.readNbt();
        this.updateTag = buf.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientExecute(PacketContext ctx) {
        Level world = ctx.getLevel();
        if (world == null) {
            return;
        }
        BlockEntity tile = world.getBlockEntity(this.pos);
        if (tile != null) {
            if (this.updateTag) {
                tile.handleUpdateTag(this.nbt, (HolderLookup.Provider)world.registryAccess());
            } else {
                tile.loadWithComponents(this.nbt, (HolderLookup.Provider)world.registryAccess());
            }
        }
    }
}

