/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.packets;

import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.zeith.hammerlib.api.config.IConfigRoot;
import org.zeith.hammerlib.core.adapter.ConfigAdapter;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.util.java.ReflectionUtil;

@MainThreaded
public class PacketSyncConfigs
implements IPacket {
    private Map<Class<? extends IConfigRoot>, IConfigRoot> toSync;
    private Map<Class<? extends IConfigRoot>, CompoundTag> fromSync;

    public PacketSyncConfigs(Map<Class<? extends IConfigRoot>, IConfigRoot> sync) {
        this.toSync = sync;
    }

    public PacketSyncConfigs() {
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeMap(this.toSync, (b, t) -> b.writeUtf(t.getCanonicalName()), (b, v) -> {
            CompoundTag nbt = new CompoundTag();
            v.toNetwork(nbt);
            b.writeNbt((Tag)nbt);
        });
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.fromSync = buf.readMap(b -> ReflectionUtil.fetchClass(b.readUtf()).asSubclass(IConfigRoot.class), b -> b.readNbt());
    }

    public Map<Class<? extends IConfigRoot>, CompoundTag> data() {
        return this.fromSync;
    }

    @Override
    public void clientExecute(PacketContext ctx) {
        ConfigAdapter.handleClientsideSync(this);
    }
}

