/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.lft;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.neoforged.neoforge.network.connection.ConnectionType;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.net.PlainHLMessage;
import org.zeith.hammerlib.net.lft.ITransportAcceptor;
import org.zeith.hammerlib.net.lft.NetTransport;

public class PacketWrapperAcceptor
implements ITransportAcceptor {
    PlainHLMessage decoded;
    byte[] data;

    @Override
    public void read(InputStream readable, int length, Supplier<RegistryAccess> registryAccess) {
        try {
            ByteBuf buf = Unpooled.buffer((int)length);
            buf.writeBytes(readable, length);
            this.data = new byte[length];
            buf.readBytes(this.data);
            buf.readerIndex(0);
            this.decoded = new PlainHLMessage(new RegistryFriendlyByteBuf(buf, registryAccess.get(), ConnectionType.NEOFORGE));
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    @Override
    public void onTransmissionComplete(PacketContext ctx) {
        if (!this.decoded.isValid()) {
            HammerLib.LOG.error("Received bad packet on packet transport (WHAT IS THIS?!): {}", (Object)new String(this.data));
        } else {
            switch (ctx.getSide()) {
                case CLIENT: {
                    this.decoded.unwrap().clientExecute(ctx);
                    break;
                }
                case SERVER: {
                    this.decoded.unwrap().serverExecute(ctx);
                    break;
                }
                default: {
                    HammerLib.LOG.error("WTF is this side {} ?!", (Object)ctx.getSide());
                }
            }
        }
        this.data = null;
        IPacket pkt = ctx.getReply();
        if (pkt != null) {
            ctx.withReply(NetTransport.wrap(pkt, ctx.registryAccess()).createPacket());
        }
    }

    @Override
    public boolean executeOnMainThread() {
        return ITransportAcceptor.super.executeOnMainThread() || this.decoded.isValid() && this.decoded.unwrap().executeOnMainThread();
    }
}

