/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.net.PacketFactory;

public class PlainHLMessage
implements CustomPacketPayload {
    IPacket packet;
    RegistryAccess registry;

    public PlainHLMessage() {
    }

    public PlainHLMessage(IPacket packet) {
        this.packet = packet;
    }

    public PlainHLMessage(RegistryFriendlyByteBuf buf) {
        this.packet = PacketFactory.createEmpty(buf.readUtf(256));
        if (this.packet != null) {
            this.packet.read(buf);
        }
        this.registry = buf.registryAccess();
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeUtf(PacketFactory.getPacketId(this.packet));
        if (this.packet != null) {
            this.packet.write(buf);
        }
    }

    public boolean isValid() {
        return this.packet != null;
    }

    public IPacket unwrap() {
        return this.packet;
    }

    public void handle(IPayloadContext ctx) {
        PacketContext pctx = new PacketContext(ctx, this.registry);
        if (this.packet != null) {
            CompletableFuture<Object> exec;
            if (this.packet.executeOnMainThread()) {
                exec = ctx.enqueueWork(() -> this.packet.execute(pctx));
            } else {
                this.packet.execute(pctx);
                exec = CompletableFuture.completedFuture(null);
            }
            exec.thenRun(() -> {
                IPacket reply = pctx.getReply();
                if (reply != null) {
                    ctx.reply((CustomPacketPayload)new PlainHLMessage(reply));
                }
            });
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return Network.MAIN_CHANNEL;
    }
}

