/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net;

import java.util.Optional;
import lombok.Generated;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.util.java.Cast;

public class PacketContext {
    private final IPayloadContext neo;
    private final ServerPlayer sender;
    private final LogicalSide side;
    private IPacket reply;
    private final RegistryAccess registryAccess;

    public PacketContext(IPayloadContext ctx, RegistryAccess registryAccess) {
        this.neo = ctx;
        this.side = ctx.flow().getReceptionSide();
        this.sender = Cast.cast(ctx.player(), ServerPlayer.class);
        this.registryAccess = registryAccess;
    }

    public RegistryAccess registryAccess() {
        Level l;
        if (this.registryAccess == null && (l = this.getLevel()) != null) {
            return l.registryAccess();
        }
        return this.registryAccess;
    }

    public boolean hasSender() {
        return this.sender != null;
    }

    public void withReply(IPacket reply) {
        this.setReply(reply);
    }

    public Level getLevel() {
        if (this.sender != null) {
            return this.sender.level();
        }
        return ((Optional)LogicalSidedProvider.CLIENTWORLD.get(this.side)).orElse(null);
    }

    private RegistryAccess getRegistryAccess() {
        return this.registryAccess;
    }

    @Generated
    public ServerPlayer getSender() {
        return this.sender;
    }

    @Generated
    public LogicalSide getSide() {
        return this.side;
    }

    @Generated
    public IPacket getReply() {
        return this.reply;
    }

    @Generated
    public IPayloadContext getNeo() {
        return this.neo;
    }

    @Generated
    public void setReply(IPacket reply) {
        this.reply = reply;
    }
}

