/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.mixins.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.zeith.hammerlib.api.items.IColoredFoilItem;
import org.zeith.hammerlib.client.render.RenderCustomGlint;
import org.zeith.hammerlib.client.render.TintingVertexConsumer;

@Mixin(value={ItemRenderer.class})
public class ItemRendererMixin {
    @Unique
    private static ItemStack hl$contextStack = ItemStack.EMPTY;

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void preRenderHook(ItemStack pItemStack, ItemDisplayContext pDisplayContext, boolean pLeftHand, PoseStack pPoseStack, MultiBufferSource pBuffer, int pCombinedLight, int pCombinedOverlay, BakedModel pModel, CallbackInfo ci) {
        hl$contextStack = pItemStack;
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void postRenderHook(ItemStack pItemStack, ItemDisplayContext pDisplayContext, boolean pLeftHand, PoseStack pPoseStack, MultiBufferSource pBuffer, int pCombinedLight, int pCombinedOverlay, BakedModel pModel, CallbackInfo ci) {
        hl$contextStack = ItemStack.EMPTY;
    }

    @Inject(method={"getArmorFoilBuffer"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getArmorFoilBufferHook(MultiBufferSource pBuffer, RenderType pRenderType, boolean pWithGlint, CallbackInfoReturnable<VertexConsumer> cir) {
        IColoredFoilItem icgi;
        if (pWithGlint && TintingVertexConsumer.tintingEnabled && !hl$contextStack.isEmpty() && (icgi = IColoredFoilItem.get(hl$contextStack)) != null) {
            int color = icgi.getFoilColor(hl$contextStack);
            cir.setReturnValue((Object)VertexMultiConsumer.create((VertexConsumer)TintingVertexConsumer.wrap(pBuffer.getBuffer(RenderCustomGlint.armorEntityGlint()), color), (VertexConsumer)pBuffer.getBuffer(pRenderType)));
        }
    }

    @Inject(method={"getCompassFoilBuffer"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getCompassFoilBufferHook(MultiBufferSource pBuffer, RenderType pRenderType, PoseStack.Pose pMatrixEntry, CallbackInfoReturnable<VertexConsumer> cir) {
        IColoredFoilItem icgi;
        if (TintingVertexConsumer.tintingEnabled && !hl$contextStack.isEmpty() && (icgi = IColoredFoilItem.get(hl$contextStack)) != null) {
            int color = icgi.getFoilColor(hl$contextStack);
            cir.setReturnValue((Object)VertexMultiConsumer.create((VertexConsumer)new SheetedDecalTextureGenerator(TintingVertexConsumer.wrap(pBuffer.getBuffer(RenderCustomGlint.glint()), color), pMatrixEntry, 0.0078125f), (VertexConsumer)pBuffer.getBuffer(pRenderType)));
        }
    }

    @Inject(method={"getCompassFoilBuffer"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getCompassFoilBufferDirectHook(MultiBufferSource pBuffer, RenderType pRenderType, PoseStack.Pose pMatrixEntry, CallbackInfoReturnable<VertexConsumer> cir) {
        IColoredFoilItem icgi;
        if (TintingVertexConsumer.tintingEnabled && !hl$contextStack.isEmpty() && (icgi = IColoredFoilItem.get(hl$contextStack)) != null) {
            int color = icgi.getFoilColor(hl$contextStack);
            cir.setReturnValue((Object)VertexMultiConsumer.create((VertexConsumer)new SheetedDecalTextureGenerator(TintingVertexConsumer.wrap(pBuffer.getBuffer(RenderCustomGlint.glintDirect()), color), pMatrixEntry, 0.0078125f), (VertexConsumer)pBuffer.getBuffer(pRenderType)));
        }
    }

    @Inject(method={"getFoilBuffer"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getFoilBufferHook(MultiBufferSource pBuffer, RenderType pRenderType, boolean pIsItem, boolean pGlint, CallbackInfoReturnable<VertexConsumer> cir) {
        IColoredFoilItem icgi;
        if (pGlint && TintingVertexConsumer.tintingEnabled && !hl$contextStack.isEmpty() && (icgi = IColoredFoilItem.get(hl$contextStack)) != null) {
            int color = icgi.getFoilColor(hl$contextStack);
            cir.setReturnValue((Object)(Minecraft.useShaderTransparency() && pRenderType == Sheets.translucentItemSheet() ? VertexMultiConsumer.create((VertexConsumer)TintingVertexConsumer.wrap(pBuffer.getBuffer(RenderCustomGlint.glintTranslucent()), color), (VertexConsumer)pBuffer.getBuffer(pRenderType)) : VertexMultiConsumer.create((VertexConsumer)TintingVertexConsumer.wrap(pBuffer.getBuffer(pIsItem ? RenderCustomGlint.glint() : RenderCustomGlint.entityGlint()), color), (VertexConsumer)pBuffer.getBuffer(pRenderType))));
        }
    }

    @Inject(method={"getFoilBufferDirect"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getFoilBufferDirectHook(MultiBufferSource pBuffer, RenderType pRenderType, boolean pNoEntity, boolean pWithGlint, CallbackInfoReturnable<VertexConsumer> cir) {
        IColoredFoilItem icgi;
        if (pWithGlint && TintingVertexConsumer.tintingEnabled && !hl$contextStack.isEmpty() && (icgi = IColoredFoilItem.get(hl$contextStack)) != null) {
            int color = icgi.getFoilColor(hl$contextStack);
            cir.setReturnValue((Object)VertexMultiConsumer.create((VertexConsumer)TintingVertexConsumer.wrap(pBuffer.getBuffer(pNoEntity ? RenderCustomGlint.glintDirect() : RenderCustomGlint.entityGlintDirect()), color), (VertexConsumer)pBuffer.getBuffer(pRenderType)));
        }
    }
}

