/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.items.tooltip;

import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import org.zeith.hammerlib.api.items.tooltip.TooltipMulti;

public class ClientTooltipMulti
implements ClientTooltipComponent {
    protected final List<ClientTooltipComponent> children;

    public ClientTooltipMulti(TooltipMulti multi) {
        this.children = multi.children().stream().map(ClientTooltipComponent::create).toList();
    }

    public int getHeight() {
        return Math.max(0, this.children.stream().mapToInt(ClientTooltipComponent::getHeight).map(i -> i + 2).sum() - 2);
    }

    public int getWidth(Font font) {
        return this.children.stream().mapToInt(c -> c.getWidth(font)).max().orElse(0);
    }

    public void renderImage(Font font, int x, int y, GuiGraphics pose) {
        for (ClientTooltipComponent child : this.children) {
            child.renderImage(font, x, y, pose);
            y += child.getHeight() + 2;
        }
    }
}

