/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.glints;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.zeith.hammerlib.api.forge.CodecsHL;
import org.zeith.hammerlib.util.colors.ColorHelper;

public record GradientGlintData(List<Integer> colors, long loopbackDurationMS) {
    public static final Codec<GradientGlintData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CodecsHL.HEX_INT_CODEC.listOf().fieldOf("colors").forGetter(GradientGlintData::colors), (App)Codec.LONG.fieldOf("duration").forGetter(GradientGlintData::loopbackDurationMS)).apply((Applicative)inst, GradientGlintData::new));
    public static final StreamCodec<ByteBuf, GradientGlintData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.list().apply(ByteBufCodecs.INT), GradientGlintData::colors, (StreamCodec)ByteBufCodecs.VAR_LONG, GradientGlintData::loopbackDurationMS, GradientGlintData::new);

    public int get(long ms) {
        long per;
        int idx;
        long startMs;
        long cur;
        int t = this.colors.size();
        if ((cur = (ms %= this.loopbackDurationMS) - (startMs = (long)(idx = (int)Math.max(0L, Math.min((long)(t - 1), ms / (per = this.loopbackDurationMS / (long)t)))) * per)) == 0L) {
            return this.colors.get(idx);
        }
        int nextIdx = idx + 1;
        while (cur < 0L) {
            cur += per;
            if (--idx >= 0 && --nextIdx >= 0) continue;
            idx += t;
            nextIdx += t;
        }
        float prog = Math.clamp((float)cur / (float)per, 0.0f, 1.0f);
        return ColorHelper.interpolate(this.colors.get(idx %= t), this.colors.get(nextIdx %= t), prog);
    }
}

