/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.objectweb.asm.Type;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.annotations.OnlyIf;
import org.zeith.hammerlib.util.java.ReflectionUtil;
import org.zeith.hammerlib.util.shaded.json.JSONObject;

public class OnlyIfAdapter {
    private static boolean recursiveGetBool(Object inst, Object objInQuestion, ResourceLocation objId, Class<?> c, String ... subs) {
        try {
            Object add = null;
            try {
                Field f = c.getDeclaredField(subs[0]);
                f.setAccessible(true);
                add = f.get(inst);
            }
            catch (NoSuchFieldException e) {
                Method m = ReflectionUtil.findDeclaredMethod(c, subs[0], mt -> mt.getParameterCount() == 0 || mt.getParameterCount() == 1 || mt.getParameterCount() == 2);
                m.setAccessible(true);
                if (m.getParameterCount() == 0) {
                    add = m.invoke(inst, new Object[0]);
                }
                if (m.getParameterCount() == 1) {
                    add = m.invoke(inst, objInQuestion);
                }
                if (m.getParameterCount() == 2) {
                    add = m.getParameterTypes()[0].isAssignableFrom(ResourceLocation.class) ? m.invoke(inst, objId, objInQuestion) : m.invoke(inst, objInQuestion, objId);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (add == null) {
                throw new NoSuchMethodException("Unable to get property of " + String.valueOf(c) + "." + subs[0]);
            }
            if (Boolean.TYPE.isAssignableFrom(add.getClass()) || Boolean.class.isAssignableFrom(add.getClass())) {
                return (Boolean)add;
            }
            if (subs.length > 1) {
                String[] subs2 = new String[subs.length - 1];
                System.arraycopy(subs, 1, subs2, 0, subs2.length);
                return OnlyIfAdapter.recursiveGetBool(add, objInQuestion, objId, add.getClass(), subs2);
            }
            throw new NoSuchMethodException("Unable to get property of " + String.valueOf(c) + "." + subs[0] + " as a boolean.");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean checkCondition(OnlyIf onlyIf, String source, String type, Object objInQuestion, ResourceLocation objId) {
        boolean add = true;
        if (onlyIf != null) {
            String member = onlyIf.member();
            try {
                String[] mp = member.split("[.]");
                Class<?> c = onlyIf.owner();
                add = OnlyIfAdapter.recursiveGetBool(null, objInQuestion, objId, c, mp);
            }
            catch (RuntimeException e) {
                Throwable err = e;
                while (err.getCause() != null) {
                    err = err.getCause();
                }
                err.printStackTrace();
                HammerLib.LOG.warn("Failed to parse @OnlyIf({}) in {}! {} will" + (onlyIf.invert() ? " not be registered due to inversion." : " be registered anyway."), new Object[]{JSONObject.quote(member), source, type});
            }
            if (onlyIf.invert()) {
                add = !add;
            }
        }
        return add;
    }

    public static OnlyIf decode(Map<String, Object> onlyIf) {
        Supplier owner = Suppliers.memoize(() -> ReflectionUtil.fetchClass((Type)onlyIf.get("owner")));
        Supplier member = Suppliers.memoize(() -> (String)onlyIf.get("member"));
        Supplier invert = Suppliers.memoize(() -> (boolean)onlyIf.getOrDefault("invert", false));
        return new OnlyIf(){
            final /* synthetic */ java.util.function.Supplier val$owner;
            final /* synthetic */ java.util.function.Supplier val$member;
            final /* synthetic */ java.util.function.Supplier val$invert;
            {
                this.val$owner = supplier;
                this.val$member = supplier2;
                this.val$invert = supplier3;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return OnlyIf.class;
            }

            @Override
            public Class<?> owner() {
                return (Class)this.val$owner.get();
            }

            @Override
            public String member() {
                return (String)this.val$member.get();
            }

            @Override
            public boolean invert() {
                return (Boolean)this.val$invert.get();
            }
        };
    }
}

