/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.items.IIngredientProvider;
import org.zeith.hammerlib.core.adapter.OreDictionaryAdapter;
import org.zeith.hammerlib.event.ParseIngredientEvent;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;
import org.zeith.hammerlib.mixins.IngredientAccessor;
import org.zeith.hammerlib.proxy.HLConstants;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.mcf.Resources;

public class RecipeHelper {
    public static final String NEOFORGE_MOD_ID_FOR_TAGS = "c";

    public static void registerCustomRecipes(HolderLookup.Provider registries, Predicate<ResourceLocation> idInUse, Consumer<RecipeHolder<?>> addRecipe, Consumer<Set<ResourceLocation>> removeRecipes, boolean silent, ICondition.IContext context) {
        RegisterRecipesEvent rre = new RegisterRecipesEvent(registries, context, idInUse);
        ModList.get().forEachModInOrder(mc -> {
            IEventBus bus = mc.getEventBus();
            if (bus == null) {
                return;
            }
            ModLoadingContext.get().setActiveContainer(mc);
            bus.post((Event)rre);
        });
        ModLoadingContext.get().setActiveContainer(null);
        rre.cleanup();
        if (!silent) {
            HLConstants.LOG.info("Reloading HammerLib recipes...");
        }
        AtomicLong count = new AtomicLong();
        rre.getRecipes().forEach(recipe -> {
            addRecipe.accept((RecipeHolder<?>)recipe);
            count.incrementAndGet();
        });
        removeRecipes.accept(rre.removedRecipes());
        if (!silent) {
            HLConstants.LOG.info("HammerLib injected {} recipes into recipe map. Removed {} recipes from the game.", (Object)count.longValue(), (Object)rre.removedRecipes().size());
        }
    }

    public static void injectRecipes(RecipeManager mgr, ICondition.IContext context, Predicate<ResourceLocation> recipeIdUsed, Consumer<RecipeHolder<?>> registrar, Consumer<ResourceLocation> delete) {
        RecipeHelper.registerCustomRecipes(mgr.registries, recipeIdUsed, registrar, s -> s.forEach(delete), false, context);
    }

    public static <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> getRecipeMap(Level level, RecipeType<T> type) {
        return level.getRecipeManager().getAllRecipesFor(type);
    }

    public static <C extends RecipeInput, T extends Recipe<C>> Stream<RecipeHolder<T>> getRecipeHolders(Level level, RecipeType<T> type) {
        return RecipeHelper.getRecipeMap(level, type).stream();
    }

    public static <C extends RecipeInput, T extends Recipe<C>> Stream<T> getRecipes(Level level, RecipeType<T> type) {
        return RecipeHelper.getRecipeHolders(level, type).map(RecipeHolder::value);
    }

    public static ItemStack cycleIngredientStack(Ingredient ingr, long displayDurationMS) {
        if (ingr.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack[] items = ingr.getItems();
        return items[(int)(System.currentTimeMillis() % ((long)items.length * displayDurationMS) / displayDurationMS) % items.length];
    }

    public static Ingredient merge(List<Ingredient> comps) {
        return RecipeHelper.merge(comps.stream());
    }

    public static Ingredient merge(Stream<Ingredient> comps) {
        return IngredientAccessor.createIngredient(comps.filter(Objects::nonNull).map(Ingredient::getValues).flatMap(Arrays::stream));
    }

    public static Ingredient fromComponent(Object comp) {
        if (comp == null) {
            return Ingredient.EMPTY;
        }
        if (comp instanceof Ingredient) {
            Ingredient i2 = (Ingredient)comp;
            return i2;
        }
        if (comp instanceof Supplier) {
            Supplier su = (Supplier)comp;
            return RecipeHelper.fromComponent(su.get());
        }
        if (comp instanceof ItemLike) {
            ItemLike il = (ItemLike)comp;
            return Ingredient.of((ItemLike[])new ItemLike[]{il});
        }
        if (comp instanceof IIngredientProvider) {
            IIngredientProvider ip = (IIngredientProvider)comp;
            return ip.asIngredient();
        }
        if (comp instanceof ItemStack) {
            ItemStack is = (ItemStack)comp;
            return Ingredient.of((ItemStack[])new ItemStack[]{is.copy()});
        }
        if (comp instanceof TagKey) {
            return RecipeHelper.fromTag((TagKey<Item>)((TagKey)comp));
        }
        if (comp instanceof ItemStack[]) {
            ItemStack[] items = (ItemStack[])comp;
            items = (ItemStack[])items.clone();
            for (int l = 0; l < items.length; ++l) {
                items[l] = items[l].copy();
            }
            return Ingredient.of((ItemStack[])items);
        }
        if (comp instanceof String || comp instanceof ResourceLocation) {
            String st = comp.toString();
            return RecipeHelper.merge(OreDictionaryAdapter.get(st).stream().map(obj -> {
                if (obj != null) {
                    ResourceLocation odConv = Cast.cast(obj, ResourceLocation.class);
                    ResourceLocation tag = odConv != null ? odConv : Resources.location((String)(st.contains(":") ? st : "c:" + st));
                    return RecipeHelper.fromTag(RecipeHelper.getItemTag(tag));
                }
                return Ingredient.EMPTY;
            }));
        }
        ParseIngredientEvent event = new ParseIngredientEvent(comp);
        HammerLib.postEvent(event);
        if (event.hasIngredient()) {
            return event.getIngredient();
        }
        if (comp.getClass().isArray()) {
            int len = Array.getLength(comp);
            return RecipeHelper.merge(IntStream.range(0, len).mapToObj(i -> RecipeHelper.fromComponent(Array.get(comp, i))));
        }
        if (comp instanceof Collection) {
            Collection col = (Collection)comp;
            return RecipeHelper.merge(col.stream().map(RecipeHelper::fromComponent));
        }
        return Ingredient.EMPTY;
    }

    public static TagKey<Item> getItemTag(ResourceLocation path) {
        return TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)path);
    }

    public static Ingredient fromTag(TagKey<Item> tag) {
        return IngredientAccessor.createIngredient(Stream.of(new Ingredient.TagValue(tag)));
    }
}

