/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.compat.rubidium;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.annotations.OnlyIf;
import org.zeith.hammerlib.client.CustomFoilConfigs;
import org.zeith.hammerlib.client.adapter.ChatMessageAdapter;
import org.zeith.hammerlib.client.render.TintingVertexConsumer;
import org.zeith.hammerlib.compat.base.BaseCompat;
import org.zeith.hammerlib.compat.base.CompatContext;
import org.zeith.hammerlib.compat.base._hl.BaseHLCompat;
import org.zeith.hammerlib.compat.rubidium.TintingVertexConsumerRB;
import org.zeith.hammerlib.util.mcf.ModHelper;

@BaseCompat.LoadCompat(modid="rubidium", compatType=BaseHLCompat.class, shouldLoad=@OnlyIf(owner=ModHelper.class, member="isClient"))
public class RubidiumCompat
extends BaseHLCompat {
    public RubidiumCompat(CompatContext ctx) {
        super(ctx);
        if (ModHelper.isModLoaded("embeddium")) {
            HammerLib.LOG.info("Detected Rubidium from Embeddium. Disabling safeguard.");
            return;
        }
        ctx.runWhenOn(Dist.CLIENT, () -> () -> {
            CustomFoilConfigs.rubidiumInstaller = this::reload;
            this.reload();
        });
        ctx.runWhenOn(Dist.DEDICATED_SERVER, () -> () -> HammerLib.LOG.error("You tried to start a dedicated server with Rubidium installed. This is probably not a good idea."));
        String url = "https://www.curseforge.com/minecraft/mc-mods/embeddium";
        MutableComponent curseforgeUri = Component.literal((String)"Embeddium").withStyle(s -> s.withColor(ChatFormatting.BLUE).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to open webpage."))));
        ChatMessageAdapter.sendOnFirstWorldLoad((Component)Component.literal((String)"WARNING: HammerLib has limited some of it's functions due to Rubidium. We recommend using ").append((Component)curseforgeUri).append(" instead, as it does causes less issues."));
    }

    public void reload() {
        if (RubidiumCompat.doesRubidiumSupportHL() && !CustomFoilConfigs.disable_with_rubidium) {
            this.enableRubidiumTint();
        } else {
            this.useFallbackRubidiumTint();
        }
    }

    public void enableRubidiumTint() {
        TintingVertexConsumer.TINT4f = TintingVertexConsumerRB::new;
        TintingVertexConsumer.TINT1i = TintingVertexConsumerRB::new;
        TintingVertexConsumer.tintingEnabled = true;
        HammerLib.LOG.info("Using Rubidium-adapted vertex consumers.");
    }

    public void useFallbackRubidiumTint() {
        TintingVertexConsumer.TINT4f = (vc, r, g, b, a) -> vc;
        TintingVertexConsumer.TINT1i = (vc, rgba) -> vc;
        TintingVertexConsumer.tintingEnabled = false;
        HammerLib.LOG.info("Using fallback vertex consumers since Rubidium is detected.");
    }

    public static boolean doesRubidiumSupportHL() {
        try {
            Class.forName("net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

