/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.zeith.hammerlib.util.mcf.Resources;

public class TooltipUtils {
    public static final ResourceLocation ENERGY_SUB = Resources.location("hammerlib", "energy");
    public static final ResourceLocation FE_DEFINITION = Resources.location("hammerlib", "fe");
    private static final ThreadLocal<List<String>> TOOLTIP = ThreadLocal.withInitial(ArrayList::new);

    public static List<String> emptyTooltipList() {
        TOOLTIP.get().clear();
        return TOOLTIP.get();
    }

    public static List<String> generateEnergy(IEnergyStorage storage) {
        if (storage == null) {
            return TooltipUtils.emptyTooltipList();
        }
        return TooltipUtils.generate(ENERGY_SUB, storage.getEnergyStored(), storage.getMaxEnergyStored(), FE_DEFINITION);
    }

    public static List<String> generate(ResourceLocation sub, int val, int max, ResourceLocation definition) {
        return TooltipUtils.generateCustom("gui." + sub.getNamespace() + "." + sub.getPath(), val, max, definition);
    }

    public static List<String> generateCustom(String i18n, int value, int max, ResourceLocation definition) {
        Object[] objectArray;
        List<String> tip = TOOLTIP.get();
        tip.clear();
        tip.add(I18n.get((String)i18n, (Object[])new Object[0]));
        String string = String.valueOf(ChatFormatting.GRAY) + "%,d" + (max > 0 ? " / %,d" : "") + " %s";
        if (max > 0) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = value;
            objectArray2[1] = max;
            objectArray = objectArray2;
            objectArray2[2] = I18n.get((String)("definition." + definition.getNamespace() + ":" + definition.getPath() + "." + (Screen.hasShiftDown() ? "long" : "short")), (Object[])new Object[0]);
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = value;
            objectArray = objectArray3;
            objectArray3[1] = I18n.get((String)("definition." + definition.getNamespace() + ":" + definition.getPath() + "." + (Screen.hasShiftDown() ? "long" : "short")), (Object[])new Object[0]);
        }
        tip.add(String.format(string, objectArray));
        return tip;
    }

    public static String intToString(long num) {
        return String.format("%,d", num);
    }
}

