/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.utils;

import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.zeith.hammerlib.client.render.item.Stack2ImageRenderer;
import org.zeith.hammerlib.util.colors.ColorHelper;
import org.zeith.hammerlib.util.mcf.Resources;

public class TexturePixelGetter {
    private static final Map<ResourceLocation, int[]> colors = new HashMap<ResourceLocation, int[]>();
    private static final Map<String, int[]> cachedRenderedColorsRaw = new HashMap<String, int[]>();
    private static final Map<String, CompletableFuture<int[]>> cachedRenderedColors = new HashMap<String, CompletableFuture<int[]>>();
    private static final Map<String, Long> cachedRenderedColorsCompletionTimes = new ConcurrentHashMap<String, Long>();
    private static final ResourceLocation MISSINGNO = TexturePixelGetter.getResourceLocation(MissingTextureAtlasSprite.getLocation());

    public static void reloadTexture(TextureAtlasStitchedEvent e) {
        cachedRenderedColorsCompletionTimes.clear();
        cachedRenderedColors.clear();
        colors.clear();
    }

    private static CompletableFuture<int[]> getRenderedColors(ItemStack stack) {
        String key = stack.toString() + "_" + String.valueOf(stack.getComponentsPatch());
        Long ct = cachedRenderedColorsCompletionTimes.get(key);
        if (ct != null && System.currentTimeMillis() - ct > 100L) {
            cachedRenderedColors.remove(key);
            cachedRenderedColorsCompletionTimes.remove(key);
        }
        return cachedRenderedColors.computeIfAbsent(key, ignore -> {
            CompletableFuture colorsFuture = new CompletableFuture();
            Stack2ImageRenderer.renderItemStack(null, 64, stack, image -> {
                colorsFuture.complete(TexturePixelGetter.decompose(image, 0));
                cachedRenderedColorsCompletionTimes.put((String)ignore, System.currentTimeMillis());
            });
            return colorsFuture;
        });
    }

    public static int[] getAllColors(ItemStack stack) {
        String key = stack.toString() + "_" + String.valueOf(stack.getComponentsPatch());
        CompletableFuture<int[]> rendered = TexturePixelGetter.getRenderedColors(stack);
        if (rendered.isDone() && !rendered.isCompletedExceptionally()) {
            int[] colors = rendered.join();
            cachedRenderedColorsRaw.put(key, colors);
            cachedRenderedColors.remove(key);
        }
        if (cachedRenderedColorsRaw.containsKey(key)) {
            return cachedRenderedColorsRaw.get(key);
        }
        Minecraft mc = Minecraft.getInstance();
        BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(stack, (Level)mc.level, (LivingEntity)mc.player, 0);
        TextureAtlasSprite spr = model.getParticleIcon(ModelData.EMPTY);
        if (spr == null) {
            spr = (TextureAtlasSprite)mc.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(MissingTextureAtlasSprite.getLocation());
        }
        return TexturePixelGetter.getAllColors(TexturePixelGetter.getResourceLocation(spr.contents().name()));
    }

    public static int[] getAllColors(ResourceLocation texture) {
        if (colors.containsKey(texture)) {
            return colors.get(texture);
        }
        if (MISSINGNO.equals((Object)texture)) {
            colors.put(texture, new int[]{0xFF00FF, 0});
        } else {
            try {
                Resource res = Minecraft.getInstance().getResourceManager().getResource(texture).orElse(null);
                if (res == null) {
                    colors.put(texture, new int[]{0xFF00FF, 0});
                    return colors.get(texture);
                }
                try (InputStream in = res.open();){
                    NativeImage img = NativeImage.read((InputStream)in);
                    colors.put(texture, TexturePixelGetter.decompose(img, 0));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                colors.put(texture, new int[]{0xFF00FF, 0});
            }
        }
        return colors.get(texture);
    }

    private static ResourceLocation getResourceLocation(ResourceLocation txPath) {
        return Resources.location(txPath.getNamespace(), String.format(Locale.ROOT, "textures/%s%s", txPath.getPath(), ".png"));
    }

    public static int[] decompose(NativeImage img, int alphaThreshold) {
        if (img == null) {
            return new int[]{0xFF00FF, 0};
        }
        IntOpenHashSet ints = new IntOpenHashSet();
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                int rgba = img.getPixelRGBA(x, y);
                int a = FastColor.ABGR32.alpha((int)rgba);
                if (a <= alphaThreshold) continue;
                int rgb = ColorHelper.packARGBi(a, FastColor.ABGR32.red((int)rgba), FastColor.ABGR32.green((int)rgba), FastColor.ABGR32.blue((int)rgba));
                ints.add(rgb);
            }
        }
        return ints.toIntArray();
    }
}

