/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntStack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class GLHelperHL {
    private static final IntStack shaders = new IntArrayList();
    private static final IntStack textures = new IntArrayList();
    public static final IShaderStack popShader = GLHelperHL::glPopShader;
    public static final ITextureStack popTexture = GLHelperHL::glPopTexture;

    public static int activeShaderProgram() {
        return GL11.glGetInteger((int)35725);
    }

    public static int getActiveUniformLoc(String name) {
        return GL20.glGetUniformLocation((int)GLHelperHL.activeShaderProgram(), (CharSequence)name);
    }

    public static int activeTexture() {
        return GL11.glGetInteger((int)32873);
    }

    public static int activeTextureWidth() {
        return GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
    }

    public static int activeTextureHeight() {
        return GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
    }

    public static void glTask(Runnable task) {
        if (RenderSystem.isOnRenderThread()) {
            task.run();
        } else {
            Minecraft.getInstance().execute(task);
        }
    }

    public static <T> T glTask(Supplier<T> task) {
        if (RenderSystem.isOnRenderThread()) {
            return task.get();
        }
        try {
            return CompletableFuture.supplyAsync(task, (Executor)Minecraft.getInstance()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void glTaskAsync(Runnable task) {
        Minecraft.getInstance().execute(task);
    }

    public static IShaderStack glPushShader() {
        shaders.push(GLHelperHL.activeShaderProgram());
        return popShader;
    }

    public static ITextureStack glPushTexture() {
        textures.push(GLHelperHL.activeTexture());
        return popTexture;
    }

    public static void glPopShader() {
        if (!shaders.isEmpty()) {
            GL20.glUseProgram((int)shaders.popInt());
        } else {
            GL20.glUseProgram((int)0);
            System.out.println("GLShaderStack underflow!");
        }
    }

    public static void glPopTexture() {
        if (!textures.isEmpty()) {
            GL11.glBindTexture((int)3553, (int)textures.popInt());
        } else {
            GL11.glBindTexture((int)3553, (int)0);
            System.out.println("GLTextureStack underflow!");
        }
    }

    @FunctionalInterface
    public static interface IShaderStack
    extends AutoCloseable {
        @Override
        public void close();

        default public int id() {
            return GLHelperHL.activeShaderProgram();
        }
    }

    @FunctionalInterface
    public static interface ITextureStack
    extends AutoCloseable {
        @Override
        public void close();

        default public int id() {
            return GLHelperHL.activeTexture();
        }
    }
}

