/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.util.java.net.HttpRequest;
import org.zeith.hammerlib.util.mcf.ModHelper;

public class HttpTextureWithHeaders
extends HttpTexture {
    public static final Map<String, String> EXTRA_HEADERS = new HashMap<String, String>();

    public HttpTextureWithHeaders(@Nullable File cacheFile, String url, ResourceLocation texturePath, boolean convertMcSkin, @Nullable Runnable onDownloaded) {
        super(cacheFile, url, texturePath, convertMcSkin, onDownloaded);
    }

    public void bind() {
        super.bind();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.location);
    }

    public void load(ResourceManager resources) throws IOException {
        if (this.future == null) {
            NativeImage nativeimage;
            if (this.file != null && this.file.isFile()) {
                LOGGER.debug("Loading http texture from local cache ({})", (Object)this.file);
                FileInputStream fileinputstream = new FileInputStream(this.file);
                nativeimage = this.load(fileinputstream);
            } else {
                nativeimage = null;
            }
            if (nativeimage != null) {
                this.loadCallback(nativeimage);
            } else {
                this.future = CompletableFuture.runAsync(() -> {
                    LOGGER.debug("Downloading http texture from {} to {}", (Object)this.urlString, (Object)this.file);
                    try (HttpRequest req = HttpRequest.get(this.urlString).useProxy(Minecraft.getInstance().getProxy()).headers(EXTRA_HEADERS);){
                        if (req.code() / 100 == 2) {
                            InputStream inputstream;
                            if (this.file != null) {
                                FileUtils.copyInputStreamToFile((InputStream)req.stream(), (File)this.file);
                                inputstream = new FileInputStream(this.file);
                            } else {
                                inputstream = req.stream();
                            }
                            NativeImage image = this.load(inputstream);
                            Minecraft.getInstance().execute(() -> {
                                if (image != null) {
                                    this.loadCallback(image);
                                }
                            });
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Couldn't download http texture", (Throwable)exception);
                    }
                }, Util.backgroundExecutor());
            }
        }
    }

    private void loadCallback(NativeImage image) {
        if (this.onDownloaded != null) {
            this.onDownloaded.run();
        }
        Minecraft.getInstance().execute(() -> {
            this.uploaded = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.upload(image));
            } else {
                this.upload(image);
            }
        });
    }

    private void upload(NativeImage image) {
        TextureUtil.prepareImage((int)this.getId(), (int)image.getWidth(), (int)image.getHeight());
        image.upload(0, 0, 0, true);
    }

    @javax.annotation.Nullable
    private NativeImage load(InputStream stream) {
        NativeImage nativeimage = null;
        try {
            nativeimage = NativeImage.read((InputStream)stream);
        }
        catch (Exception exception) {
            LOGGER.warn("Error while loading the URL texture", (Throwable)exception);
        }
        return nativeimage;
    }

    static {
        EXTRA_HEADERS.put("User-Agent", "HammerLib-based HTTP Texture Downloader (" + ModHelper.getModVersion("hammerlib") + ")");
    }
}

