/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.render;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.neoforged.neoforge.client.model.pipeline.VertexConsumerWrapper;
import org.zeith.hammerlib.util.colors.ColorHelper;
import org.zeith.hammerlib.util.java.functions.Function2;
import org.zeith.hammerlib.util.java.functions.Function5;

public class TintingVertexConsumer
extends VertexConsumerWrapper {
    protected float a;
    protected float r;
    protected float g;
    protected float b;
    public static boolean tintingEnabled = true;
    public static Function2<VertexConsumer, Integer, VertexConsumer> TINT1i = TintingVertexConsumer::new;
    public static Function5<VertexConsumer, Float, Float, Float, Float, VertexConsumer> TINT4f = TintingVertexConsumer::new;

    protected TintingVertexConsumer(VertexConsumer parent, int rgba) {
        super(parent);
        this.r = ColorHelper.getRed(rgba);
        this.g = ColorHelper.getGreen(rgba);
        this.b = ColorHelper.getBlue(rgba);
        this.a = ColorHelper.getAlpha(rgba);
    }

    protected TintingVertexConsumer(VertexConsumer parent, float r, float g, float b, float a) {
        super(parent);
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public static VertexConsumer wrap(VertexConsumer parent, int rgba) {
        return TINT1i.apply(parent, rgba);
    }

    public static VertexConsumer wrap(VertexConsumer parent, float r, float g, float b, float a) {
        return TINT4f.apply(parent, Float.valueOf(r), Float.valueOf(g), Float.valueOf(b), Float.valueOf(a));
    }

    public VertexConsumer setColor(int pRed, int pGreen, int pBlue, int pAlpha) {
        pRed = (int)((float)pRed * this.r);
        pGreen = (int)((float)pGreen * this.g);
        pBlue = (int)((float)pBlue * this.b);
        pAlpha = (int)((float)pAlpha * this.a);
        this.parent.setColor(pRed, pGreen, pBlue, pAlpha);
        return this;
    }
}

