/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.model.builtin;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.client.model.IGroupedQuadModel;
import org.zeith.hammerlib.client.model.IUnbakedGeometry;
import org.zeith.hammerlib.client.model.LoadUnbakedGeometry;
import org.zeith.hammerlib.client.model.builtin.GroupedModel;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;
import org.zeith.hammerlib.util.mcf.Resources;

@LoadUnbakedGeometry(path="multi_layer")
public class MultiLayerModel
implements IUnbakedGeometry<MultiLayerModel> {
    private static final IntList EG = IntList.of();
    protected final List<BlockElement> elements;
    protected final IntList ungrouped;
    protected final Map<String, IntList> groups = new HashMap<String, IntList>();
    protected final Map<String, String> textures = new HashMap<String, String>();

    public MultiLayerModel(JsonObject obj, JsonDeserializationContext context) {
        this.elements = this.getElements(context, obj);
        if (obj.has("textures")) {
            JsonObject arr = obj.getAsJsonObject("textures");
            for (String id : arr.keySet()) {
                this.textures.put(id, GsonHelper.getAsString((JsonObject)arr, (String)id));
            }
        }
        for (BlockElement element : this.elements) {
            element.faces.replaceAll((dir, value) -> {
                if (value.texture().startsWith("#")) {
                    String ntx = this.textures.getOrDefault(value.texture().substring(1), "missing");
                    return new BlockElementFace(value.cullForDirection(), value.tintIndex(), ntx, value.uv(), value.faceData(), value.parent());
                }
                return value;
            });
        }
        IntArrayList ungrouped = new IntArrayList();
        for (int i = 0; i < this.elements.size(); ++i) {
            ungrouped.add(i);
        }
        if (obj.has("groups")) {
            JsonArray arr = obj.getAsJsonArray("groups");
            for (JsonElement el : arr) {
                JsonObject groupJson = el.getAsJsonObject();
                this.parseGroup("", groupJson).forEach(g -> this.groups.computeIfAbsent((String)g.a(), ke -> new IntArrayList()).addAll((IntList)g.b()));
            }
        }
        this.ungrouped = ungrouped;
    }

    protected List<Tuple2<String, IntList>> parseGroup(String prefix, JsonObject group) {
        ArrayList lst = Lists.newArrayList();
        String name = GsonHelper.getAsString((JsonObject)group, (String)"name");
        IntArrayList thisGroup = new IntArrayList();
        JsonArray childrenJson = group.getAsJsonArray("children");
        for (int i = 0; i < childrenJson.size(); ++i) {
            JsonElement elem = childrenJson.get(i);
            if (elem.isJsonPrimitive()) {
                thisGroup.add(elem.getAsInt());
                continue;
            }
            if (!elem.isJsonObject()) continue;
            lst.addAll(this.parseGroup(prefix + name + "/", elem.getAsJsonObject()));
        }
        if (!thisGroup.isEmpty()) {
            lst.add(Tuples.immutable(prefix + name, thisGroup));
        }
        return lst;
    }

    public IntList getGroup(String name) {
        if (name == null) {
            return this.ungrouped;
        }
        return this.groups.getOrDefault(name, EG);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        try {
            ArrayList quads = Lists.newArrayList();
            Int2ObjectArrayMap toGroup = new Int2ObjectArrayMap();
            int[][] quadOffsetsAndCounts = new int[this.elements.size()][];
            for (int i = 0; i < this.elements.size(); ++i) {
                List baked = UnbakedGeometryHelper.bakeElements(List.of(this.elements.get(i)), spriteGetter, (ModelState)modelState);
                for (int j = quads.size(); j < quads.size() + baked.size(); ++j) {
                    String group = null;
                    for (Map.Entry<String, IntList> entry : this.groups.entrySet()) {
                        if (!entry.getValue().contains(j)) continue;
                        group = entry.getKey();
                        break;
                    }
                    toGroup.put(j, group);
                }
                quadOffsetsAndCounts[i] = new int[]{quads.size(), quads.size() + baked.size()};
                quads.addAll(baked);
            }
            TextureAtlasSprite particle = spriteGetter.apply(new Material(InventoryMenu.BLOCK_ATLAS, Resources.location(this.textures.getOrDefault("particle", "particle"))));
            ResourceLocation renderTypeHint = context.getRenderTypeHint();
            RenderTypeGroup renderTypes = renderTypeHint != null ? context.getRenderType(renderTypeHint) : RenderTypeGroup.EMPTY;
            return new MultiLayerBakedModel(quads, context.useAmbientOcclusion(), context.useBlockLight(), context.isGui3d(), particle, context.getTransforms(), overrides, renderTypes, this::getGroup, quadOffsetsAndCounts, (Int2ObjectArrayMap<String>)toGroup);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    protected List<BlockElement> getElements(JsonDeserializationContext ctx, JsonObject root) {
        ArrayList list = Lists.newArrayList();
        if (root.has("elements")) {
            for (JsonElement jsonelement : GsonHelper.getAsJsonArray((JsonObject)root, (String)"elements")) {
                list.add((BlockElement)ctx.deserialize(jsonelement, BlockElement.class));
            }
        }
        return list;
    }

    public static class MultiLayerBakedModel
    extends SimpleBakedModel
    implements IGroupedQuadModel {
        protected final int[][] quadOffsetsAndCounts;
        protected final Int2ObjectArrayMap<String> toGroup;
        protected final Function<String, IntList> quadIndices;
        protected final MultiLayerItemBakedModel itemModel;
        public static final Function<RenderType, String> RT_KEYS = ((HashMap)Util.make(new HashMap(), map -> {
            map.put(RenderType.solid(), "solid");
            map.put(RenderType.cutoutMipped(), "cutout_mipped");
            map.put(RenderType.cutout(), "cutout");
            map.put(RenderType.translucent(), "translucent");
            map.put(RenderType.tripwire(), "tripwire");
        }))::get;

        public MultiLayerBakedModel(List<BakedQuad> unculledFaces, boolean hasAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, TextureAtlasSprite particleIcon, ItemTransforms transforms, ItemOverrides overrides, RenderTypeGroup renderTypes, Function<String, IntList> quadIndices, int[][] quadOffsetsAndCounts, Int2ObjectArrayMap<String> toGroup) {
            super(unculledFaces, GroupedModel.CULLED_QUADS, hasAmbientOcclusion, usesBlockLight, isGui3d, particleIcon, transforms, overrides, renderTypes);
            this.quadIndices = quadIndices;
            this.quadOffsetsAndCounts = quadOffsetsAndCounts;
            this.toGroup = toGroup;
            this.itemModel = new MultiLayerItemBakedModel(unculledFaces, GroupedModel.CULLED_QUADS, hasAmbientOcclusion, usesBlockLight, isGui3d, particleIcon, transforms, overrides, renderTypes);
        }

        @Override
        public Stream<BakedQuad> getGroupedUnculledQuads(String group) {
            return this.quadIndices.apply(group).intStream().mapToObj(id -> this.quadOffsetsAndCounts[id]).flatMap(id -> IntStream.range(id[0], id[1]).mapToObj(this.unculledFaces::get));
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
            String group = RT_KEYS.apply(renderType);
            if (group == null || side == null) {
                return List.of();
            }
            return this.getGroupedUnculledQuads(group).toList();
        }

        public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
            return List.of(this);
        }

        public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
            return ChunkRenderTypeSet.all();
        }
    }

    public static class MultiLayerItemBakedModel
    extends SimpleBakedModel {
        public MultiLayerItemBakedModel(List<BakedQuad> p_119489_, Map<Direction, List<BakedQuad>> p_119490_, boolean p_119491_, boolean p_119492_, boolean p_119493_, TextureAtlasSprite p_119494_, ItemTransforms p_119495_, ItemOverrides p_119496_, RenderTypeGroup renderTypes) {
            super(p_119489_, p_119490_, p_119491_, p_119492_, p_119493_, p_119494_, p_119495_, p_119496_, renderTypes);
        }
    }
}

