/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Constructor;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import org.jetbrains.annotations.ApiStatus;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.annotations.OnlyIf;
import org.zeith.hammerlib.client.model.IUnbakedGeometry;
import org.zeith.hammerlib.client.model.LoadUnbakedGeometry;
import org.zeith.hammerlib.core.adapter.OnlyIfAdapter;
import org.zeith.hammerlib.util.configured.io.UnsafeHax;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.mcf.Resources;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;
import org.zeith.hammerlib.util.shaded.json.JSONObject;

public class SimpleModelGenerator<T extends IUnbakedGeometry<T>>
implements IGeometryLoader<T> {
    private final BiFunction<JsonObject, JsonDeserializationContext, T> factory;

    public SimpleModelGenerator(BiFunction<JsonObject, JsonDeserializationContext, T> factory) {
        this.factory = factory;
    }

    public T read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
        return (T)((IUnbakedGeometry)this.factory.apply(jsonObject, deserializationContext));
    }

    @ApiStatus.Internal
    public static void setup() {
        for (ScanDataHelper.ModAwareAnnotationData data : ScanDataHelper.lookupAnnotatedObjects(LoadUnbakedGeometry.class)) {
            Class<?> cTmp = data.getOwnerClass();
            if (!IUnbakedGeometry.class.isAssignableFrom(cTmp)) continue;
            Class<IUnbakedGeometry> c = cTmp.asSubclass(IUnbakedGeometry.class);
            String path = data.getProperty("path").map(String.class::cast).orElseThrow();
            BiFunction<JsonObject, JsonDeserializationContext, IUnbakedGeometry> factory = (json, context) -> (IUnbakedGeometry)Cast.cast(UnsafeHax.unitializedInstance(c));
            ResourceLocation loaderId = Resources.location(data.getOwnerMod().map(ModContainer::getModId).orElse("hammerlib"), path);
            OnlyIf condition = null;
            for (Constructor<?> ctor : c.getDeclaredConstructors()) {
                condition = ctor.getDeclaredAnnotation(OnlyIf.class);
                if (!OnlyIfAdapter.checkCondition(condition, c.toString(), "UnbakedModel", null, loaderId)) continue;
                if (ctor.getParameterCount() == 2 && (ctor.getParameterTypes()[0].isAssignableFrom(JsonObject.class) && ctor.getParameterTypes()[1].isAssignableFrom(JsonDeserializationContext.class) || ctor.getParameterTypes()[0].isAssignableFrom(JsonDeserializationContext.class) && ctor.getParameterTypes()[1].isAssignableFrom(JsonObject.class))) {
                    boolean flip = ctor.getParameterTypes()[0].isAssignableFrom(JsonDeserializationContext.class);
                    Constructor<?> ctxCtor = ctor;
                    factory = (json, context) -> {
                        try {
                            ctxCtor.setAccessible(true);
                            return (IUnbakedGeometry)Cast.cast(flip ? ctxCtor.newInstance(context, json) : ctxCtor.newInstance(json, context));
                        }
                        catch (Throwable err) {
                            err.printStackTrace();
                            return (IUnbakedGeometry)Cast.cast(UnsafeHax.unitializedInstance(c));
                        }
                    };
                    break;
                }
                if (ctor.getParameterCount() == 1 && ctor.getParameterTypes()[0].isAssignableFrom(JsonObject.class)) {
                    Constructor<?> ctxCtor = ctor;
                    factory = (json, context) -> {
                        try {
                            ctxCtor.setAccessible(true);
                            return (IUnbakedGeometry)Cast.cast(ctxCtor.newInstance(json));
                        }
                        catch (Throwable err) {
                            err.printStackTrace();
                            return (IUnbakedGeometry)Cast.cast(UnsafeHax.unitializedInstance(c));
                        }
                    };
                    break;
                }
                if (ctor.getParameterCount() != 1 || !ctor.getParameterTypes()[0].isAssignableFrom(JsonDeserializationContext.class)) continue;
                Constructor<?> ctxCtor = ctor;
                factory = (json, context) -> {
                    try {
                        ctxCtor.setAccessible(true);
                        return (IUnbakedGeometry)Cast.cast(ctxCtor.newInstance(context));
                    }
                    catch (Throwable err) {
                        err.printStackTrace();
                        return (IUnbakedGeometry)Cast.cast(UnsafeHax.unitializedInstance(c));
                    }
                };
                break;
            }
            if (condition == null) {
                try {
                    condition = c.getDeclaredConstructor(new Class[0]).getDeclaredAnnotation(OnlyIf.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            BiFunction<JsonObject, JsonDeserializationContext, IUnbakedGeometry> factoryFinal = factory;
            if (!OnlyIfAdapter.checkCondition(condition, c.toString(), "UnbakedModel", null, loaderId)) continue;
            data.getOwnerMod().ifPresent(mc -> mc.getEventBus().addListener(evt -> {
                evt.register(Resources.location(mc.getNamespace(), path), new SimpleModelGenerator(factoryFinal));
                HammerLib.LOG.info("Registered a new model with loader {} of type {}", (Object)JSONObject.quote(mc.getNamespace() + ":" + path), (Object)c.getName());
            }));
        }
    }
}

