/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.objects;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import org.zeith.hammerlib.client.flowgui.Graphics;
import org.zeith.hammerlib.client.flowgui.GuiObject;
import org.zeith.hammerlib.client.flowgui.MousePos;
import org.zeith.hammerlib.client.flowgui.util.GuiObjectHelper;
import org.zeith.hammerlib.client.flowgui.util.ScrollData;
import org.zeith.hammerlib.util.math.Point;

public class GuiRootObject
extends GuiObject
implements GuiEventListener,
Renderable,
NarratableEntry {
    protected boolean focused;
    protected Runnable tickHandler = () -> {};
    protected FloatConsumer preRenderHandler = f -> {};
    public boolean debugBoundaries;
    public int debugBoundaryColor = -39322;

    public GuiRootObject() {
        super("$root");
    }

    public GuiRootObject onTick(Runnable task) {
        Runnable prev = this.tickHandler;
        this.tickHandler = () -> {
            prev.run();
            task.run();
        };
        return this;
    }

    public GuiRootObject onPreRender(FloatConsumer task) {
        this.preRenderHandler = this.preRenderHandler.andThen(task);
        return this;
    }

    public final GuiRootObject add(GuiObject o) {
        this.addChild(o);
        return this;
    }

    @Override
    protected void update() {
        this.tickHandler.run();
    }

    @Override
    protected void render(Graphics gfx, MousePos pos) {
        this.preRenderHandler.accept(gfx.partialTime());
    }

    public PoseStack myPose() {
        return new PoseStack();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.sendMouseClick(this.myPose(), new Point(mouseX, mouseY), button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.sendMouseDrag(this.myPose(), new Point(mouseX, mouseY), button, new Point(dragX, dragY));
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.sendMouseRelease(this.myPose(), new Point(mouseX, mouseY), button);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        return this.sendMouseScroll(this.myPose(), new Point(pMouseX, pMouseY), new ScrollData(pScrollX, pScrollY));
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.sendMouseMove(this.myPose(), new Point(mouseX, mouseY));
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        return this.sendKeyPress(pKeyCode, pScanCode, pModifiers);
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        return this.sendKeyRelease(pKeyCode, pScanCode, pModifiers);
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        return this.sendCharType(pCodePoint, pModifiers);
    }

    public void setFocused(boolean pFocused) {
        this.focused = pFocused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        float x = (float)(mc.mouseHandler.xpos() * (double)mc.getWindow().getGuiScaledWidth() / (double)mc.getWindow().getScreenWidth());
        float y = (float)(mc.mouseHandler.ypos() * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getScreenHeight());
        Graphics g = Graphics.builder().gfx(gfx).game(Minecraft.getInstance()).partialTime(partialTick).debugBounds(this.debugBoundaries).build();
        this.renderObject(g, new Point(x, y));
        this.drawDebugOverlay(g);
    }

    public void drawDebugOverlay(Graphics g) {
        if (g.debugBounds()) {
            int color = this.debugBoundaryColor;
            for (Rect2i rect : GuiObjectHelper.getAllAreas(this)) {
                g.renderOutline(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), color);
            }
        }
    }

    public void updateNarration(NarrationElementOutput output) {
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public boolean isMouseOver(double pMouseX, double pMouseY) {
        return true;
    }
}

