/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.Slot;
import org.zeith.hammerlib.client.flowgui.GuiObject;
import org.zeith.hammerlib.client.flowgui.objects.GuiButtonObject;
import org.zeith.hammerlib.client.flowgui.objects.GuiImageObject;
import org.zeith.hammerlib.client.flowgui.objects.GuiSlotLinkObject;
import org.zeith.hammerlib.client.flowgui.objects.GuiTextObject;

public class GuiObjectBuilder {
    private final String name;

    public GuiObjectBuilder(String name) {
        this.name = name;
    }

    public static GuiObjectBuilder named(String name) {
        return new GuiObjectBuilder(name);
    }

    public GuiObject empty() {
        return new GuiObject(this.name);
    }

    public GuiSlotLinkObject slot(Slot slot) {
        return new GuiSlotLinkObject(this.name).bindToSlot(slot);
    }

    public GuiImageObject image(ResourceLocation tex, float uOffset, float vOffset, int width, int height, int txWidth, int txHeight) {
        return new GuiImageObject(this.name, tex, uOffset, vOffset, width, height, txWidth, txHeight);
    }

    public GuiImageObject image(ResourceLocation tex, float uOffset, float vOffset, int width, int height) {
        return this.image(tex, uOffset, vOffset, width, height, 256, 256);
    }

    public GuiTextObject text(Font font, FormattedCharSequence text, int color, boolean shadow) {
        return new GuiTextObject(this.name, font, text, color, shadow);
    }

    public GuiTextObject text(Component text, int color, boolean shadow) {
        return this.text(Minecraft.getInstance().font, text.getVisualOrderText(), color, shadow);
    }

    public GuiTextObject text(Component text) {
        return this.text(text, -1, true);
    }

    public GuiButtonObject.GuiButtonObjectBuilder button() {
        return GuiButtonObject.builder(this.name);
    }
}

