/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record IngredientWithCount(Ingredient input, int count) {
    public static final MapCodec<IngredientWithCount> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("input").forGetter(IngredientWithCount::input), (App)Codec.INT.fieldOf("count").forGetter(IngredientWithCount::count)).apply((Applicative)inst, IngredientWithCount::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, IngredientWithCount> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, IngredientWithCount::input, (StreamCodec)ByteBufCodecs.INT, IngredientWithCount::count, IngredientWithCount::new);
    public static final IngredientWithCount EMPTY = new IngredientWithCount(Ingredient.EMPTY, 0);

    public boolean isEmpty() {
        return this.input.isEmpty() || this.count <= 0;
    }

    public NonNullList<Ingredient> applyCount() {
        return NonNullList.withSize((int)this.count, (Object)this.input);
    }

    public boolean test(ItemStack item) {
        return this.input.test(item) && item.getCount() >= this.count;
    }

    public void toNetwork(RegistryFriendlyByteBuf buf) {
        STREAM_CODEC.encode((Object)buf, (Object)this);
    }

    public static IngredientWithCount fromNetwork(RegistryFriendlyByteBuf buf) {
        return (IngredientWithCount)STREAM_CODEC.decode((Object)buf);
    }
}

