/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.items.coms;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.stream.IntStream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammerlib.api.items.IColoredFoilItem;
import org.zeith.hammerlib.api.items.glint.IGlintProviderType;
import org.zeith.hammerlib.core.RegistriesHL;
import org.zeith.hammerlib.core.glints.GradientGlintData;
import org.zeith.hammerlib.core.init.GlintProviderTypesHL;
import org.zeith.hammerlib.util.java.Cast;

public record CustomGlintComponent<T>(IGlintProviderType<T> type, T data) implements IColoredFoilItem
{
    public static final Codec<CustomGlintComponent<?>> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)RegistriesHL.GLINT_PROVIDERS.byNameCodec().fieldOf("type").forGetter(CustomGlintComponent::type), (App)ExtraCodecs.JSON.fieldOf("data").forGetter(CustomGlintComponent::serializeData)).apply((Applicative)inst, CustomGlintComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CustomGlintComponent<?>> STREAM_CODEC = StreamCodec.of(CustomGlintComponent::toNetwork, CustomGlintComponent::fromNetwork);

    public CustomGlintComponent(IGlintProviderType<T> type, JsonElement data) {
        this(type, type.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)data).result().map(Pair::getFirst).orElse(null));
    }

    private JsonElement serializeData() {
        return (JsonElement)this.type.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, this.data).result().orElseThrow();
    }

    @Override
    public int getFoilColor(@NotNull ItemStack stack) {
        return this.type.getGlint(stack, this.data);
    }

    public static CustomGlintComponent<?> fixedColor(int color) {
        return new CustomGlintComponent<Integer>(GlintProviderTypesHL.CONSTANT, color);
    }

    public static CustomGlintComponent<?> rainbow(long fullCycleMS) {
        return new CustomGlintComponent<Long>(GlintProviderTypesHL.RAINBOW, fullCycleMS);
    }

    public static CustomGlintComponent<?> gradient(long fullCycleMS, int ... colors) {
        return new CustomGlintComponent<GradientGlintData>(GlintProviderTypesHL.GRADIENT, new GradientGlintData(IntStream.of(colors).boxed().toList(), fullCycleMS));
    }

    public static <T> void toNetwork(RegistryFriendlyByteBuf buf, CustomGlintComponent<T> com) {
        IGlintProviderType<T> h = com.type();
        buf.writeResourceLocation(buf.registryAccess().registryOrThrow(RegistriesHL.Keys.GLINT_PROVIDERS).getKey(h));
        h.streamCodec().encode((Object)((ByteBuf)Cast.cast(buf)), com.data());
    }

    public static CustomGlintComponent<?> fromNetwork(RegistryFriendlyByteBuf buf) {
        IGlintProviderType type = (IGlintProviderType)buf.registryAccess().registryOrThrow(RegistriesHL.Keys.GLINT_PROVIDERS).getOrThrow(buf.readResourceKey(RegistriesHL.Keys.GLINT_PROVIDERS));
        Object decode = type.streamCodec().decode((Object)((ByteBuf)Cast.cast(buf)));
        return new CustomGlintComponent<Object>(type, decode);
    }
}

