/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.io.serializers;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammerlib.api.io.serializers.INBTSerializer;
import org.zeith.hammerlib.util.java.Cast;

public class EnumNBTSerializer<ET extends Enum<ET>>
implements INBTSerializer<ET> {
    final Class<ET> type;
    final ET[] constants;

    public EnumNBTSerializer(Class<ET> type) {
        this.type = type;
        this.constants = (Enum[])type.getEnumConstants();
    }

    public static EnumNBTSerializer<?> create(Class<? extends Enum<?>> type) {
        return new EnumNBTSerializer((Class)Cast.cast(type));
    }

    @Override
    public void serialize(HolderLookup.Provider provider, String key, @NotNull ET value, CompoundTag nbt) {
        if (value != null) {
            nbt.putInt(key, ((Enum)value).ordinal());
        }
    }

    @Override
    public ET deserialize(HolderLookup.Provider provider, String key, CompoundTag nbt) {
        if (nbt.contains(key, 3)) {
            return this.constants[Math.abs(nbt.getInt(key)) % this.constants.length];
        }
        return null;
    }
}

