/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.io.serializers;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammerlib.api.io.serializers.INBTSerializer;

public class BaseCodecSerializer<T>
implements INBTSerializer<T> {
    protected final Codec<T> codec;
    protected final Supplier<T> defaultValue;

    public BaseCodecSerializer(Codec<T> codec, Supplier<T> defaultValue) {
        this.codec = codec;
        this.defaultValue = defaultValue;
    }

    @Override
    public void serialize(HolderLookup.Provider provider, String key, @NotNull T value, CompoundTag nbt) {
        this.codec.encodeStart((DynamicOps)NbtOps.INSTANCE, value).result().ifPresent(tag -> nbt.put(key, tag));
    }

    @Override
    public T deserialize(HolderLookup.Provider provider, String key, CompoundTag nbt) {
        Tag tag = nbt.get(key);
        if (tag != null) {
            return (T)this.codec.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).result().map(Pair::getFirst).orElseGet(this.defaultValue);
        }
        return this.defaultValue.get();
    }
}

