/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.abstractions.sources;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.zeith.hammerlib.abstractions.sources.IObjectSource;
import org.zeith.hammerlib.abstractions.sources.IObjectSourceType;
import org.zeith.hammerlib.core.init.SourceTypesHL;
import org.zeith.hammerlib.util.java.Cast;

public class TileSourceType
implements IObjectSourceType {
    public IObjectSource<BlockEntity> readSource(CompoundTag tag) {
        return new TileSource(tag);
    }

    public static class TileSource
    implements IObjectSource<BlockEntity> {
        public final BlockPos pos;

        public TileSource(BlockPos pos) {
            this.pos = pos;
        }

        public TileSource(CompoundTag tag) {
            this.pos = new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
        }

        @Override
        public CompoundTag writeSource() {
            CompoundTag tag = new CompoundTag();
            tag.putInt("x", this.pos.getX());
            tag.putInt("y", this.pos.getY());
            tag.putInt("z", this.pos.getZ());
            return tag;
        }

        @Override
        public IObjectSourceType getType() {
            return SourceTypesHL.TILE_TYPE;
        }

        @Override
        public Class<BlockEntity> getBaseType() {
            return BlockEntity.class;
        }

        @Override
        public BlockEntity get(Level world) {
            return Cast.cast(world.getBlockEntity(this.pos), BlockEntity.class);
        }
    }
}

