/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.flag;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagUniverse;

public final class FeatureFlagSet {
    private static final FeatureFlagSet EMPTY = new FeatureFlagSet(null, 0L);
    public static final int MAX_CONTAINER_SIZE = 64;
    @Nullable
    private final FeatureFlagUniverse universe;
    private final long mask;

    private FeatureFlagSet(@Nullable FeatureFlagUniverse p_250433_, long p_251523_) {
        this.universe = p_250433_;
        this.mask = p_251523_;
    }

    static FeatureFlagSet create(FeatureFlagUniverse p_251573_, Collection<FeatureFlag> p_251037_) {
        if (p_251037_.isEmpty()) {
            return EMPTY;
        }
        long $$2 = FeatureFlagSet.computeMask(p_251573_, 0L, p_251037_);
        return new FeatureFlagSet(p_251573_, $$2);
    }

    public static FeatureFlagSet of() {
        return EMPTY;
    }

    public static FeatureFlagSet of(FeatureFlag p_252331_) {
        return new FeatureFlagSet(p_252331_.universe, p_252331_.mask);
    }

    public static FeatureFlagSet of(FeatureFlag p_251008_, FeatureFlag ... p_249805_) {
        long $$2 = p_249805_.length == 0 ? p_251008_.mask : FeatureFlagSet.computeMask(p_251008_.universe, p_251008_.mask, Arrays.asList(p_249805_));
        return new FeatureFlagSet(p_251008_.universe, $$2);
    }

    private static long computeMask(FeatureFlagUniverse p_249684_, long p_250982_, Iterable<FeatureFlag> p_251734_) {
        for (FeatureFlag $$3 : p_251734_) {
            if (p_249684_ != $$3.universe) {
                throw new IllegalStateException("Mismatched feature universe, expected '" + String.valueOf(p_249684_) + "', but got '" + String.valueOf($$3.universe) + "'");
            }
            p_250982_ |= $$3.mask;
        }
        return p_250982_;
    }

    public boolean contains(FeatureFlag p_249521_) {
        if (this.universe != p_249521_.universe) {
            return false;
        }
        return (this.mask & p_249521_.mask) != 0L;
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public boolean isSubsetOf(FeatureFlagSet p_249164_) {
        if (this.universe == null) {
            return true;
        }
        if (this.universe != p_249164_.universe) {
            return false;
        }
        return (this.mask & (p_249164_.mask ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
    }

    public boolean intersects(FeatureFlagSet p_341635_) {
        if (this.universe == null || p_341635_.universe == null || this.universe != p_341635_.universe) {
            return false;
        }
        return (this.mask & p_341635_.mask) != 0L;
    }

    public FeatureFlagSet join(FeatureFlagSet p_251527_) {
        if (this.universe == null) {
            return p_251527_;
        }
        if (p_251527_.universe == null) {
            return this;
        }
        if (this.universe != p_251527_.universe) {
            throw new IllegalArgumentException("Mismatched set elements: '" + String.valueOf(this.universe) + "' != '" + String.valueOf(p_251527_.universe) + "'");
        }
        return new FeatureFlagSet(this.universe, this.mask | p_251527_.mask);
    }

    public FeatureFlagSet subtract(FeatureFlagSet p_341688_) {
        if (this.universe == null || p_341688_.universe == null) {
            return this;
        }
        if (this.universe != p_341688_.universe) {
            throw new IllegalArgumentException("Mismatched set elements: '" + String.valueOf(this.universe) + "' != '" + String.valueOf(p_341688_.universe) + "'");
        }
        long $$1 = this.mask & (p_341688_.mask ^ 0xFFFFFFFFFFFFFFFFL);
        if ($$1 == 0L) {
            return EMPTY;
        }
        return new FeatureFlagSet(this.universe, $$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_248691_) {
        if (this == p_248691_) {
            return true;
        }
        if (!(p_248691_ instanceof FeatureFlagSet)) return false;
        FeatureFlagSet $$1 = (FeatureFlagSet)p_248691_;
        if (this.universe != $$1.universe) return false;
        if (this.mask != $$1.mask) return false;
        return true;
    }

    public int hashCode() {
        return (int)HashCommon.mix((long)this.mask);
    }
}

