/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.References;

public class EntityEquipmentToArmorAndHandFix
extends DataFix {
    public EntityEquipmentToArmorAndHandFix(Schema p_15417_, boolean p_15418_) {
        super(p_15417_, p_15418_);
    }

    public TypeRewriteRule makeRule() {
        return this.cap(this.getInputSchema().getTypeRaw(References.ITEM_STACK));
    }

    private <IS> TypeRewriteRule cap(Type<IS> p_15427_) {
        Type $$1 = DSL.and((Type)DSL.optional((Type)DSL.field((String)"Equipment", (Type)DSL.list(p_15427_))), (Type)DSL.remainderType());
        Type $$2 = DSL.and((Type)DSL.optional((Type)DSL.field((String)"ArmorItems", (Type)DSL.list(p_15427_))), (Type)DSL.optional((Type)DSL.field((String)"HandItems", (Type)DSL.list(p_15427_))), (Type)DSL.optional((Type)DSL.field((String)"body_armor_item", p_15427_)), (Type)DSL.remainderType());
        OpticFinder $$3 = DSL.typeFinder((Type)$$1);
        OpticFinder $$4 = DSL.fieldFinder((String)"Equipment", (Type)DSL.list(p_15427_));
        return this.fixTypeEverywhereTyped("EntityEquipmentToArmorAndHandFix", this.getInputSchema().getType(References.ENTITY), this.getOutputSchema().getType(References.ENTITY), p_326763_ -> {
            Either $$5 = Either.right((Object)DSL.unit());
            Either $$6 = Either.right((Object)DSL.unit());
            Either $$7 = Either.right((Object)DSL.unit());
            Dynamic $$8 = (Dynamic)p_326763_.getOrCreate(DSL.remainderFinder());
            Optional $$9 = p_326763_.getOptional($$4);
            if ($$9.isPresent()) {
                List $$10 = (List)$$9.get();
                Object $$11 = ((Pair)p_15427_.read($$8.emptyMap()).result().orElseThrow(() -> new IllegalStateException("Could not parse newly created empty itemstack."))).getFirst();
                if (!$$10.isEmpty()) {
                    $$5 = Either.left((Object)Lists.newArrayList((Object[])new Object[]{$$10.get(0), $$11}));
                }
                if ($$10.size() > 1) {
                    ArrayList $$12 = Lists.newArrayList((Object[])new Object[]{$$11, $$11, $$11, $$11});
                    for (int $$13 = 1; $$13 < Math.min($$10.size(), 5); ++$$13) {
                        $$12.set($$13 - 1, $$10.get($$13));
                    }
                    $$6 = Either.left((Object)$$12);
                }
            }
            Dynamic $$14 = $$8;
            Optional $$15 = $$8.get("DropChances").asStreamOpt().result();
            if ($$15.isPresent()) {
                Iterator $$16 = Stream.concat((Stream)$$15.get(), Stream.generate(() -> $$14.createInt(0))).iterator();
                float $$17 = ((Dynamic)$$16.next()).asFloat(0.0f);
                if ($$8.get("HandDropChances").result().isEmpty()) {
                    Dynamic $$18 = $$8.createList(Stream.of(Float.valueOf($$17), Float.valueOf(0.0f)).map(arg_0 -> ((Dynamic)$$8).createFloat(arg_0)));
                    $$8 = $$8.set("HandDropChances", $$18);
                }
                if ($$8.get("ArmorDropChances").result().isEmpty()) {
                    Dynamic $$19 = $$8.createList(Stream.of(Float.valueOf(((Dynamic)$$16.next()).asFloat(0.0f)), Float.valueOf(((Dynamic)$$16.next()).asFloat(0.0f)), Float.valueOf(((Dynamic)$$16.next()).asFloat(0.0f)), Float.valueOf(((Dynamic)$$16.next()).asFloat(0.0f))).map(arg_0 -> ((Dynamic)$$8).createFloat(arg_0)));
                    $$8 = $$8.set("ArmorDropChances", $$19);
                }
                $$8 = $$8.remove("DropChances");
            }
            return p_326763_.set($$3, $$2, (Object)Pair.of((Object)$$5, (Object)Pair.of((Object)$$6, (Object)Pair.of((Object)$$7, (Object)$$8))));
        });
    }
}

